/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.util;

import io.sitoolkit.cv.core.infra.util.ClassLoaderUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdkUtils.class);

    private JdkUtils() {
    }

    public static boolean isJdkToolsJarLoaded() {
        try {
            Class.forName("com.sun.tools.javac.tree.JCTree");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean loadJdkToosJar() {
        String javaHome = System.getProperty("java.home");
        Path toolsJar = Paths.get(javaHome, "/lib/tools.jar");
        if (!toolsJar.toFile().exists()) {
            toolsJar = Paths.get(javaHome, "../lib/tools.jar").normalize();
        }
        if (!toolsJar.toFile().exists()) {
            return false;
        }
        return ClassLoaderUtils.addPathToClasspath(toolsJar);
    }
}

