/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.lombok;

import io.sitoolkit.cv.core.infra.lombok.DelombokParameter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.launch.Delombok;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Delomboker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Delomboker.class);

    public void execute(DelombokParameter param) {
        log.debug("Delomboking {} ...", (Object)param.src.toAbsolutePath());
        try {
            Delombok delombok = new Delombok();
            delombok.addDirectory(param.src.toFile());
            if (param.target != null) {
                delombok.setOutput(param.target.toFile());
            }
            if (param.encoding != null) {
                delombok.setCharset(param.encoding);
            }
            if (param.classpath != null) {
                delombok.setClasspath(param.classpath.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
            }
            if (param.sourcepath != null) {
                delombok.setSourcepath(param.sourcepath.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
            }
            delombok.delombok();
            log.info("Delomboked in {} to {}", (Object)param.src, (Object)param.target);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Delombok failed : {}", (Object)param.src.toAbsolutePath(), (Object)e);
        }
    }
}

