/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.graphviz;

import io.sitoolkit.cv.core.infra.SitRepository;
import io.sitoolkit.cv.core.infra.util.SitFileUtils;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySettingService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import lombok.Generated;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ZipUtil;

public class GraphvizManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphvizManager.class);
    private static String winGraphvizDownloadUrl;
    private static String winGraphvizInstallFile;
    private static GraphvizManager graphvizManager;

    private GraphvizManager() {
    }

    public static void initialize() {
        if (SystemUtils.IS_OS_WINDOWS && graphvizManager == null) {
            graphvizManager = new GraphvizManager();
            graphvizManager.loadProperties();
            graphvizManager.checkBinary();
            GraphvizUtils.setDotExecutable((String)graphvizManager.getBinaryPath().toAbsolutePath().toString());
        }
    }

    private Path getGraphvizPath() {
        return SitRepository.getRepositoryPath().resolve("graphviz");
    }

    private Path getBinaryPath() {
        return this.getGraphvizPath().resolve("release/bin/dot.exe");
    }

    private void loadProperties() {
        ResourceBundle rb = ResourceBundle.getBundle("graphviz");
        winGraphvizDownloadUrl = rb.getString("win.graphviz.downloadUrl");
        winGraphvizInstallFile = rb.getString("win.graphviz.installFile");
    }

    private void checkBinary() {
        Path binaryPath = this.getBinaryPath();
        if (Files.exists(binaryPath, new LinkOption[0])) {
            log.info("Executable Graphviz found in SitRepository : {}", (Object)binaryPath);
        } else {
            log.info("Graphviz not found in SitRepository");
            this.installGraphviz();
        }
    }

    private void installGraphviz() {
        SitFileUtils.createDirectories(this.getGraphvizPath());
        this.installGraphvizWindows();
    }

    private void installGraphvizWindows() {
        log.info("Installing Graphviz...");
        this.downloadWindowsBinary();
        this.extractBinary();
        log.info("Finished Installing Graphviz");
    }

    private void downloadWindowsBinary() {
        Path zipFile = this.getGraphvizPath().resolve(winGraphvizInstallFile);
        if (Files.exists(zipFile, new LinkOption[0])) {
            log.info("zipFile exists :{}", (Object)zipFile.toString());
        } else {
            ProxySettingService.getInstance().loadProxy();
            try {
                URL url = new URL(winGraphvizDownloadUrl);
                log.info("downloading zipFile from '{}' ... ", (Object)url);
                FileUtils.copyURLToFile((URL)url, (File)zipFile.toFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void extractBinary() {
        Path zipFile = this.getGraphvizPath().resolve(winGraphvizInstallFile);
        log.info("extracting zipfile '{}' ... ", (Object)zipFile);
        ZipUtil.unpack((File)zipFile.toFile(), (File)this.getGraphvizPath().toFile());
        if (!Files.exists(this.getBinaryPath(), new LinkOption[0])) {
            log.error("graphviz executable not found at '{}' ", (Object)this.getBinaryPath().toAbsolutePath());
            throw new IllegalStateException("graphviz executable not found at " + this.getBinaryPath().toAbsolutePath());
        }
    }
}

