/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.config;

import io.sitoolkit.cv.core.infra.config.SitCvConfig;
import io.sitoolkit.cv.core.infra.util.JsonUtils;
import io.sitoolkit.cv.core.infra.util.SitResourceUtils;
import io.sitoolkit.cv.core.infra.watcher.FileInputSourceWatcher;
import io.sitoolkit.cv.core.infra.watcher.InputSourceWatcher;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitCvConfigReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SitCvConfigReader.class);
    private static final String CONFIG_FILE_NAME = "sit-cv-config.json";
    private static SitCvConfig config;
    private volatile Path baseDir;
    private List<Consumer<SitCvConfig>> configListeners = new ArrayList<Consumer<SitCvConfig>>();
    private InputSourceWatcher watcher = new FileInputSourceWatcher();

    public SitCvConfig read(Path dir) {
        if (config == null) {
            config = this.readConfig(dir);
            this.baseDir = dir;
            this.startWatch();
        } else {
            log.info("SitCvConfig is already loaded: {}", (Object)this.baseDir);
        }
        return config;
    }

    private SitCvConfig readConfig(Path baseDir) {
        URL url = this.getConfigURL(baseDir);
        log.info("Read config:{}", (Object)url.toString());
        SitCvConfig config = JsonUtils.url2obj(url, SitCvConfig.class);
        config.setSourceUrl(url);
        return config;
    }

    private URL getConfigURL(Path baseDir) {
        Path configFilePath = baseDir.resolve(CONFIG_FILE_NAME);
        if (!configFilePath.toFile().exists()) {
            return SitResourceUtils.getResourceUrl(SitCvConfig.class, CONFIG_FILE_NAME);
        }
        try {
            return configFilePath.toAbsolutePath().normalize().toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void startWatch() {
        Path configFilePath = this.baseDir.resolve(CONFIG_FILE_NAME);
        if (!configFilePath.toFile().exists()) {
            return;
        }
        this.watcher.setContinue(true);
        this.watcher.watch(configFilePath.toAbsolutePath().toString());
        this.watcher.start(inputSources -> {
            List<Consumer<SitCvConfig>> listeners;
            this.reload();
            SitCvConfigReader sitCvConfigReader = this;
            synchronized (sitCvConfigReader) {
                listeners = this.configListeners;
            }
            log.debug("config listeners: {}", (Object)listeners.toString());
            listeners.forEach(listener -> listener.accept(config));
        });
    }

    public synchronized void addChangeListener(Consumer<SitCvConfig> listener) {
        this.configListeners.add(listener);
    }

    private synchronized void reload() {
        JsonUtils.url2obj(config.getSourceUrl(), config);
    }
}

