/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.uml.plantuml;

import io.sitoolkit.cv.core.domain.classdef.TypeDef;
import io.sitoolkit.cv.core.domain.functionmodel.Diagram;
import io.sitoolkit.cv.core.domain.uml.BranchSequenceElement;
import io.sitoolkit.cv.core.domain.uml.CatchSequenceGroup;
import io.sitoolkit.cv.core.domain.uml.ConditionalSequenceGroup;
import io.sitoolkit.cv.core.domain.uml.DiagramWriter;
import io.sitoolkit.cv.core.domain.uml.FinallySequenceGroup;
import io.sitoolkit.cv.core.domain.uml.LifeLineDef;
import io.sitoolkit.cv.core.domain.uml.LoopSequenceGroup;
import io.sitoolkit.cv.core.domain.uml.MessageDef;
import io.sitoolkit.cv.core.domain.uml.SequenceDiagram;
import io.sitoolkit.cv.core.domain.uml.SequenceElement;
import io.sitoolkit.cv.core.domain.uml.SequenceElementWriter;
import io.sitoolkit.cv.core.domain.uml.TrySequenceGroup;
import io.sitoolkit.cv.core.domain.uml.plantuml.IdentiferFormatter;
import io.sitoolkit.cv.core.domain.uml.plantuml.PlantUmlWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceDiagramWriterPlantUmlImpl
implements DiagramWriter<SequenceDiagram>,
SequenceElementWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SequenceDiagramWriterPlantUmlImpl.class);
    private final String PARAM_INDENT = "  ";
    @NonNull
    PlantUmlWriter plantumlWriter;
    IdentiferFormatter idFormatter = new IdentiferFormatter();

    public List<String> write(List<SequenceDiagram> diagrams) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("@startuml");
        lines.addAll(diagrams.stream().map(diagram -> this.lifeline2str(diagram.getEntryLifeLine())).flatMap(Collection::stream).collect(Collectors.toList()));
        lines.add("@enduml");
        return lines;
    }

    @Override
    public Diagram write(SequenceDiagram diagram) {
        return this.plantumlWriter.createDiagram(diagram, this::serialize);
    }

    public String serialize(SequenceDiagram diagram) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("@startuml");
        lines.addAll(this.message2str("[", diagram.getEntryLifeLine().getEntryMessage()));
        lines.add("@enduml");
        String umlString = lines.stream().collect(Collectors.joining(System.lineSeparator()));
        log.info("Serialized Diagram :\n{}", (Object)umlString);
        return umlString;
    }

    protected List<String> lifeline2str(LifeLineDef lifeLine) {
        List<String> lifeLineStrings = lifeLine.getElements().stream().map(element -> element.write(lifeLine, this)).flatMap(Collection::stream).collect(Collectors.toList());
        lifeLineStrings.add(0, "activate " + lifeLine.getObjectName());
        lifeLineStrings.add("deactivate " + lifeLine.getObjectName());
        return lifeLineStrings;
    }

    protected List<String> message2str(String sourceName, MessageDef message) {
        LifeLineDef target = message.getTarget();
        List<String> list = this.lifeline2str(target);
        list.add(0, sourceName + "-> " + target.getObjectName() + " :[[#{" + message.getRequestQualifiedSignature() + "} " + this.idFormatter.format(this.buildRequestName(message)) + "]]");
        String responseName = this.type2Str(message.getResponseType());
        if (!StringUtils.equals((CharSequence)responseName, (CharSequence)"void")) {
            list.add(list.size() - 1, sourceName + "<-- " + target.getObjectName() + " :" + this.idFormatter.format(responseName));
        }
        return list;
    }

    protected String buildRequestName(MessageDef message) {
        String paramNames = "";
        if (message.getRequestParamTypes().size() > 0) {
            String separator = this.plantumlWriter.LINE_SEPARATOR + "  ";
            paramNames = separator + message.getRequestParamTypes().stream().map(this::type2Str).collect(Collectors.joining("," + separator));
        }
        return message.getRequestName() + "(" + paramNames + ")";
    }

    protected String type2Str(TypeDef type) {
        if (type.getVariable() == null) {
            return type.toString();
        }
        return type.getVariable() + ": " + type.toString();
    }

    public void writeToFile(List<SequenceDiagram> diagrams, Path filePath) {
        try {
            Files.write(filePath, this.write(diagrams), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> elements2str(LifeLineDef lifeLine, List<? extends SequenceElement> elements) {
        return elements.stream().map(childElement -> childElement.write(lifeLine, this)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<String> write(LifeLineDef lifeLine, LoopSequenceGroup group) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("loop " + this.escapeLineSeparator(group.getScope()));
        list.addAll(this.elements2str(lifeLine, group.getElements()));
        list.add("end");
        return list;
    }

    @Override
    public List<String> write(LifeLineDef lifeLine, ConditionalSequenceGroup group) {
        ArrayList<String> list = new ArrayList<String>();
        String altType = group.isFirst() ? "alt" : "else";
        list.add(altType + " " + this.escapeLineSeparator(group.getCondition()));
        list.addAll(this.elements2str(lifeLine, group.getElements()));
        return list;
    }

    @Override
    public List<String> write(LifeLineDef lifeLine, BranchSequenceElement group) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.elements2str(lifeLine, group.getConditions()));
        list.add("end");
        return list;
    }

    @Override
    public List<String> write(LifeLineDef lifeLine, TrySequenceGroup group) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("group try");
        list.addAll(this.elements2str(lifeLine, group.getElements()));
        list.addAll(this.elements2str(lifeLine, group.getCatchGroups()));
        if (group.getFinallyGroup() != null) {
            list.addAll(group.getFinallyGroup().write(lifeLine, this));
        }
        list.add("end");
        return list;
    }

    @Override
    public List<String> write(LifeLineDef lifeLine, CatchSequenceGroup group) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("else catch " + this.escapeLineSeparator(group.getParameter()));
        list.addAll(this.elements2str(lifeLine, group.getElements()));
        return list;
    }

    @Override
    public List<String> write(LifeLineDef lifeLine, FinallySequenceGroup group) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("else finally");
        list.addAll(this.elements2str(lifeLine, group.getElements()));
        return list;
    }

    @Override
    public List<String> write(LifeLineDef lifeLine, MessageDef message) {
        return this.message2str(lifeLine.getObjectName(), message);
    }

    private String escapeLineSeparator(String str) {
        return str.replaceAll("(\r\n|\n)", this.plantumlWriter.ESCAPED_LINE_SEPARATOR);
    }

    @Generated
    public SequenceDiagramWriterPlantUmlImpl(@NonNull PlantUmlWriter plantumlWriter) {
        if (plantumlWriter == null) {
            throw new NullPointerException("plantumlWriter is marked @NonNull but is null");
        }
        this.plantumlWriter = plantumlWriter;
    }
}

