/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.uml.plantuml;

import io.sitoolkit.cv.core.domain.functionmodel.Diagram;
import io.sitoolkit.cv.core.domain.uml.DiagramModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;

public class PlantUmlWriter {
    public final String LINE_SEPARATOR = "\\n\\\n";
    public final String ESCAPED_LINE_SEPARATOR = "\\\\n\\\\\n";

    public <T extends DiagramModel> Diagram createDiagram(T model, Function<T, String> serializer) {
        Diagram diagram = new Diagram();
        diagram.setId(model.getId());
        diagram.setTags(model.getAllTags());
        diagram.setApiDocs(model.getAllApiDocs());
        SourceStringReader reader = new SourceStringReader(serializer.apply(model));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            reader.outputImage((OutputStream)baos, new FileFormatOption(FileFormat.SVG));
            diagram.setData(baos.toByteArray());
            return diagram;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

