/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.project.maven;

import io.sitoolkit.cv.core.app.config.ServiceFactory;
import io.sitoolkit.cv.core.domain.project.Project;
import io.sitoolkit.cv.core.domain.project.ProjectReader;
import io.sitoolkit.cv.core.domain.project.analyze.SqlLogProcessor;
import io.sitoolkit.cv.core.domain.project.maven.MavenProjectInfoListener;
import io.sitoolkit.cv.core.infra.config.SitCvConfig;
import io.sitoolkit.cv.core.infra.config.SitCvConfigReader;
import io.sitoolkit.cv.core.infra.project.SitCvToolsManager;
import io.sitoolkit.util.buildtoolhelper.maven.MavenProject;
import io.sitoolkit.util.buildtoolhelper.process.StdoutListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class MavenProjectReader
implements ProjectReader {
    @NonNull
    private SqlLogProcessor sqlLogProcessor;

    public static void main(String[] args) {
        Path projectDir = Paths.get(args[0], new String[0]);
        SitCvConfigReader configReader = new SitCvConfigReader();
        SitCvConfig config = configReader.read(projectDir);
        ServiceFactory factory = ServiceFactory.create(projectDir);
        Project project = factory.getProjectManager().getCurrentProject();
        new MavenProjectReader(new SqlLogProcessor()).generateSqlLog(project, config);
    }

    @Override
    public Optional<Project> read(Path projectDir) {
        MavenProject mvnPrj = MavenProject.load((Path)projectDir);
        if (!mvnPrj.available()) {
            return Optional.empty();
        }
        MavenProjectInfoListener listener = new MavenProjectInfoListener(projectDir);
        mvnPrj.mvnw(new String[]{"compile", "-X"}).stdout((StdoutListener)listener).execute();
        return Optional.of(listener.getProject());
    }

    @Override
    public boolean generateSqlLog(Project project, SitCvConfig sitCvConfig) {
        MavenProject mvnPrj = MavenProject.load((Path)project.getDir());
        if (!mvnPrj.available()) {
            return false;
        }
        SitCvToolsManager.initialize(project.getWorkDir());
        Path agentJar = SitCvToolsManager.getInstance().getJarPath();
        this.sqlLogProcessor.process("maven", sitCvConfig, agentJar, project, agentParam -> mvnPrj.mvnw(new String[]{"test", "-DargLine=" + agentParam}));
        return true;
    }

    @Generated
    public MavenProjectReader(@NonNull SqlLogProcessor sqlLogProcessor) {
        if (sqlLogProcessor == null) {
            throw new NullPointerException("sqlLogProcessor is marked @NonNull but is null");
        }
        this.sqlLogProcessor = sqlLogProcessor;
    }
}

