/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.project.maven;

import io.sitoolkit.cv.core.domain.project.Project;
import io.sitoolkit.util.buildtoolhelper.process.StdoutListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectInfoListener
implements StdoutListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MavenProjectInfoListener.class);
    private final Project project;
    private Project recordingProject;

    public MavenProjectInfoListener(Path projectDir) {
        this.project = new Project(projectDir);
    }

    public void nextLine(String line) {
        String classpathsStr;
        String javaSrcDirsStr;
        String javaBuildDirStr;
        log.debug(line);
        String javaBaseDirStr = StringUtils.substringAfterLast((String)line, (String)"[DEBUG]   (f) basedir = ");
        if (StringUtils.isNotEmpty((CharSequence)javaBaseDirStr)) {
            this.recordBaseDirStr(javaBaseDirStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(javaBuildDirStr = StringUtils.substringAfterLast((String)line, (String)"[DEBUG]   (f) buildDirectory = ")))) {
            this.recordBuildDirStr(javaBuildDirStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(javaSrcDirsStr = StringUtils.substringBetween((String)line, (String)"[DEBUG]   (f) compileSourceRoots = [", (String)"]")))) {
            this.recordSrcDirsStr(javaSrcDirsStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(classpathsStr = StringUtils.substringBetween((String)line, (String)"[DEBUG]   (f) classpathElements = [", (String)"]")))) {
            this.recordClasspathsStr(classpathsStr);
        }
    }

    void recordBaseDirStr(String javaBaseDirStr) {
        Path javaBaseDir = Paths.get(javaBaseDirStr, new String[0]);
        if (this.project.getDir().equals(javaBaseDir)) {
            this.recordingProject = this.project;
        } else {
            this.recordingProject = new Project(javaBaseDir);
            this.project.getSubProjects().add(this.recordingProject);
        }
    }

    void recordBuildDirStr(String javaBuildDirStr) {
        if (this.recordingProject != null) {
            this.recordingProject.setBuildDir(Paths.get(javaBuildDirStr, new String[0]));
        }
    }

    void recordSrcDirsStr(String javaSrcDirsStr) {
        if (this.recordingProject != null) {
            this.recordingProject.setSrcDirs(this.splitAndTrim(javaSrcDirsStr));
        }
    }

    void recordClasspathsStr(String classpathsStr) {
        if (this.recordingProject != null) {
            this.recordingProject.setClasspaths(this.splitAndTrim(classpathsStr));
        }
    }

    private Set<Path> splitAndTrim(String line) {
        return Arrays.asList(line.split(",")).stream().map(String::trim).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet());
    }

    @Generated
    public Project getProject() {
        return this.project;
    }
}

