/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.project.gradle;

import io.sitoolkit.cv.core.domain.project.Project;
import io.sitoolkit.util.buildtoolhelper.process.StdoutListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleProjectInfoListener
implements StdoutListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GradleProjectInfoListener.class);
    private final Project project;
    private Project recordingProject;

    public GradleProjectInfoListener(Path projectDir) {
        this.project = new Project(projectDir);
    }

    public void nextLine(String line) {
        String classpathStr;
        String javaSrcDirStr;
        String javaBuildDirStr;
        log.debug(line);
        String javaBaseDirStr = StringUtils.substringAfter((String)line, (String)"sitCvProjectDir:");
        if (StringUtils.isNotEmpty((CharSequence)javaBaseDirStr)) {
            this.recordBaseDirStr(javaBaseDirStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(javaBuildDirStr = StringUtils.substringAfter((String)line, (String)"sitCvBuildDir:")))) {
            this.recordBuildDirStr(javaBuildDirStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(javaSrcDirStr = StringUtils.substringAfter((String)line, (String)"sitCvJavaSrcDir:")))) {
            this.recordSrcDirStr(javaSrcDirStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(classpathStr = StringUtils.substringAfter((String)line, (String)"sitCvClasspath:")))) {
            this.recordClasspathStr(classpathStr);
        }
    }

    void recordBaseDirStr(String javaBaseDirStr) {
        Path javaBaseDir = Paths.get(javaBaseDirStr, new String[0]);
        if (this.project.getDir().equals(javaBaseDir)) {
            this.recordingProject = this.project;
        } else {
            this.recordingProject = new Project(javaBaseDir);
            this.project.getSubProjects().add(this.recordingProject);
        }
    }

    void recordBuildDirStr(String javaBuildDirStr) {
        if (this.recordingProject != null) {
            this.recordingProject.setBuildDir(Paths.get(javaBuildDirStr, new String[0]));
        }
    }

    void recordSrcDirStr(String javaSrcDirStr) {
        if (this.recordingProject != null) {
            this.recordingProject.getSrcDirs().add(Paths.get(javaSrcDirStr, new String[0]));
        }
    }

    void recordClasspathStr(String classpathStr) {
        if (this.recordingProject != null) {
            this.recordingProject.getClasspaths().add(Paths.get(classpathStr, new String[0]));
        }
    }

    @Generated
    public Project getProject() {
        return this.project;
    }
}

