/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.project;

import com.fasterxml.jackson.core.type.TypeReference;
import io.sitoolkit.cv.core.domain.crud.SqlPerMethod;
import io.sitoolkit.cv.core.domain.project.Project;
import io.sitoolkit.cv.core.domain.project.ProjectReader;
import io.sitoolkit.cv.core.domain.project.lombok.DelombokProcessor;
import io.sitoolkit.cv.core.infra.config.SitCvConfig;
import io.sitoolkit.cv.core.infra.util.JsonUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class ProjectManager {
    @NonNull
    private List<ProjectReader> readers;
    @NonNull
    private SitCvConfig sitCvConfig;
    private Project currentProject;

    public void load(Path projectDir) {
        Optional<Project> project = this.readers.stream().map(reader -> reader.read(projectDir)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (!project.isPresent()) {
            throw new IllegalArgumentException("Project is not supported " + projectDir);
        }
        this.currentProject = project.get();
        this.currentProject.getAllProjects().forEach(proj -> DelombokProcessor.of(proj).ifPresent(proj::setPreProcessor));
    }

    public Optional<List<SqlPerMethod>> getSqlLog() {
        return JsonUtils.file2obj(this.currentProject.getSqlLogPath(), new TypeReference<List<SqlPerMethod>>(){});
    }

    public void generateSqlLog() {
        this.readers.stream().filter(reader -> reader.generateSqlLog(this.currentProject, this.sitCvConfig)).findFirst();
    }

    @Generated
    public ProjectManager(@NonNull List<ProjectReader> readers, @NonNull SitCvConfig sitCvConfig) {
        if (readers == null) {
            throw new NullPointerException("readers is marked @NonNull but is null");
        }
        if (sitCvConfig == null) {
            throw new NullPointerException("sitCvConfig is marked @NonNull but is null");
        }
        this.readers = readers;
        this.sitCvConfig = sitCvConfig;
    }

    @Generated
    public Project getCurrentProject() {
        return this.currentProject;
    }
}

