/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.crud;

import io.sitoolkit.cv.core.domain.crud.CrudType;
import io.sitoolkit.cv.core.domain.tabledef.TableDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;

public class CrudRow {
    private String actionPath;
    private Map<TableDef, Set<CrudType>> cellMap = new HashMap<TableDef, Set<CrudType>>();
    private Map<TableDef, Set<String>> sqlTextMap = new HashMap<TableDef, Set<String>>();
    private List<String> repositoryFunctions = new ArrayList<String>();

    public CrudRow(String actionPath) {
        this.actionPath = actionPath;
    }

    public void add(TableDef table, CrudType type, String sqlText) {
        Set types = this.cellMap.computeIfAbsent(table, key -> new HashSet());
        types.add(type);
        Set sqls = this.sqlTextMap.computeIfAbsent(table, key -> new HashSet());
        sqls.add(sqlText);
    }

    public CrudRow merge(CrudRow mergingCrud) {
        mergingCrud.getCellMap().entrySet().stream().forEach(cellMapEntry -> {
            Set existingSet = this.cellMap.computeIfAbsent((TableDef)cellMapEntry.getKey(), (Function<TableDef, Set<CrudType>>)((Function<TableDef, Set>)key -> new HashSet()));
            existingSet.addAll((Collection)cellMapEntry.getValue());
        });
        mergingCrud.getSqlTextMap().entrySet().stream().forEach(sqlTextMapEntry -> {
            Set existingSet = this.sqlTextMap.computeIfAbsent((TableDef)sqlTextMapEntry.getKey(), (Function<TableDef, Set<String>>)((Function<TableDef, Set>)key -> new HashSet()));
            existingSet.addAll((Collection)sqlTextMapEntry.getValue());
        });
        this.repositoryFunctions.addAll(mergingCrud.getRepositoryFunctions());
        return mergingCrud;
    }

    @Generated
    public CrudRow() {
    }

    @Generated
    public String getActionPath() {
        return this.actionPath;
    }

    @Generated
    public Map<TableDef, Set<CrudType>> getCellMap() {
        return this.cellMap;
    }

    @Generated
    public Map<TableDef, Set<String>> getSqlTextMap() {
        return this.sqlTextMap;
    }

    @Generated
    public List<String> getRepositoryFunctions() {
        return this.repositoryFunctions;
    }

    @Generated
    public void setActionPath(String actionPath) {
        this.actionPath = actionPath;
    }

    @Generated
    public void setCellMap(Map<TableDef, Set<CrudType>> cellMap) {
        this.cellMap = cellMap;
    }

    @Generated
    public void setSqlTextMap(Map<TableDef, Set<String>> sqlTextMap) {
        this.sqlTextMap = sqlTextMap;
    }

    @Generated
    public void setRepositoryFunctions(List<String> repositoryFunctions) {
        this.repositoryFunctions = repositoryFunctions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrudRow)) {
            return false;
        }
        CrudRow other = (CrudRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$actionPath = this.getActionPath();
        String other$actionPath = other.getActionPath();
        if (this$actionPath == null ? other$actionPath != null : !this$actionPath.equals(other$actionPath)) {
            return false;
        }
        Map<TableDef, Set<CrudType>> this$cellMap = this.getCellMap();
        Map<TableDef, Set<CrudType>> other$cellMap = other.getCellMap();
        if (this$cellMap == null ? other$cellMap != null : !((Object)this$cellMap).equals(other$cellMap)) {
            return false;
        }
        Map<TableDef, Set<String>> this$sqlTextMap = this.getSqlTextMap();
        Map<TableDef, Set<String>> other$sqlTextMap = other.getSqlTextMap();
        if (this$sqlTextMap == null ? other$sqlTextMap != null : !((Object)this$sqlTextMap).equals(other$sqlTextMap)) {
            return false;
        }
        List<String> this$repositoryFunctions = this.getRepositoryFunctions();
        List<String> other$repositoryFunctions = other.getRepositoryFunctions();
        return !(this$repositoryFunctions == null ? other$repositoryFunctions != null : !((Object)this$repositoryFunctions).equals(other$repositoryFunctions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CrudRow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $actionPath = this.getActionPath();
        result = result * 59 + ($actionPath == null ? 43 : $actionPath.hashCode());
        Map<TableDef, Set<CrudType>> $cellMap = this.getCellMap();
        result = result * 59 + ($cellMap == null ? 43 : ((Object)$cellMap).hashCode());
        Map<TableDef, Set<String>> $sqlTextMap = this.getSqlTextMap();
        result = result * 59 + ($sqlTextMap == null ? 43 : ((Object)$sqlTextMap).hashCode());
        List<String> $repositoryFunctions = this.getRepositoryFunctions();
        result = result * 59 + ($repositoryFunctions == null ? 43 : ((Object)$repositoryFunctions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CrudRow(actionPath=" + this.getActionPath() + ", cellMap=" + this.getCellMap() + ", sqlTextMap=" + this.getSqlTextMap() + ", repositoryFunctions=" + this.getRepositoryFunctions() + ")";
    }
}

