/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef.javaparser;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import io.sitoolkit.cv.core.domain.classdef.BranchStatement;
import io.sitoolkit.cv.core.domain.classdef.CatchStatement;
import io.sitoolkit.cv.core.domain.classdef.ConditionalStatement;
import io.sitoolkit.cv.core.domain.classdef.CvStatement;
import io.sitoolkit.cv.core.domain.classdef.CvStatementDefaultImpl;
import io.sitoolkit.cv.core.domain.classdef.FinallyStatement;
import io.sitoolkit.cv.core.domain.classdef.LoopStatement;
import io.sitoolkit.cv.core.domain.classdef.MethodCallDef;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.classdef.TryStatement;
import io.sitoolkit.cv.core.domain.classdef.javaparser.DeclationProcessor;
import java.util.Stack;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisitContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VisitContext.class);
    private Stack<CvStatement> stack = new Stack();

    public static VisitContext of(CvStatement current) {
        VisitContext context = new VisitContext();
        context.startContext(current);
        return context;
    }

    public void startLoopContext(Node node, String scope) {
        LoopStatement loopStatement = DeclationProcessor.createLoopStatement(node, scope);
        if (!this.stack.isEmpty()) {
            this.addChild(this.getCurrent(), loopStatement);
        }
        this.startContext(loopStatement);
    }

    public void startBranchContext(IfStmt ifStmt) {
        BranchStatement branchStatement = DeclationProcessor.createBranchStatement(ifStmt);
        if (!this.stack.isEmpty()) {
            this.addChild(this.getCurrent(), branchStatement);
        }
        this.startContext(branchStatement);
    }

    public void addConditionalContext(Statement statement, String condition, boolean isFirst) {
        ConditionalStatement conditionalStatement = DeclationProcessor.createConditionalStatement(statement, condition, isFirst);
        this.addChild(this.getCurrentBranch(), conditionalStatement);
        this.startContext(conditionalStatement);
    }

    public void startTryContext(TryStmt tryStmt) {
        TryStatement tryStatement = DeclationProcessor.createTryStatement(tryStmt);
        if (!this.stack.isEmpty()) {
            this.addChild(this.getCurrent(), tryStatement);
        }
        this.startContext(tryStatement);
    }

    public void startCatchContext(CatchClause catchClause, String parameter) {
        CatchStatement catchStatement = DeclationProcessor.createCatchStatement(catchClause, parameter);
        if (!this.stack.isEmpty()) {
            this.addChild(this.getCurrent(), catchStatement);
        }
        this.startContext(catchStatement);
    }

    public void startFinallyContext(Statement stmt) {
        FinallyStatement finallyStatement = DeclationProcessor.createFinallyStatement(stmt);
        if (!this.stack.isEmpty()) {
            this.addChild(this.getCurrent(), finallyStatement);
        }
        this.startContext(finallyStatement);
    }

    public void startContext(CvStatement startingStatement) {
        this.stack.push(startingStatement);
        log.debug("{}Start context : {}", (Object)this.getLogLeftPadding(), (Object)startingStatement);
    }

    public void endContext() {
        CvStatement endingStatement = this.stack.pop();
        log.debug("{}End context : {}", (Object)this.getLogLeftPadding(), (Object)endingStatement);
    }

    public CvStatement getCurrent() {
        return this.stack.peek();
    }

    public CvStatement getCurrentBranch() {
        return this.stack.stream().filter(BranchStatement.class::isInstance).reduce((first, second) -> second).get();
    }

    public CvStatement getCurrentMethod() {
        return this.stack.stream().filter(MethodDef.class::isInstance).reduce((first, second) -> second).get();
    }

    public void addMethodCall(MethodCallDef methodCallDef) {
        log.debug("{}Add MethodCall {} to {}", new Object[]{this.getLogLeftPadding(), methodCallDef, this.getCurrent()});
        CvStatement currentMethod = this.getCurrentMethod();
        if (currentMethod != null) {
            ((MethodDef)currentMethod).getMethodCalls().add(methodCallDef);
        }
        this.addChild(this.getCurrent(), methodCallDef);
    }

    public boolean isInLoop() {
        return this.getCurrent() instanceof LoopStatement;
    }

    public String getLogLeftPadding() {
        return StringUtils.repeat((String)"-", (int)this.stack.size()) + " ";
    }

    private void addChild(CvStatement parent, CvStatement child) {
        if (parent instanceof TryStatement && child instanceof CatchStatement) {
            ((TryStatement)parent).getCatchStatements().add((CatchStatement)child);
        } else if (parent instanceof TryStatement && child instanceof FinallyStatement) {
            ((TryStatement)parent).setFinallyStatement((FinallyStatement)child);
        } else if (parent instanceof CvStatementDefaultImpl) {
            ((CvStatementDefaultImpl)parent).getChildren().add(child);
        } else if (parent instanceof MethodDef) {
            ((MethodDef)parent).getStatements().add(child);
        } else if (parent instanceof BranchStatement && child instanceof ConditionalStatement) {
            ((BranchStatement)parent).getConditions().add((ConditionalStatement)child);
        } else {
            log.warn("Illegal operation for {}", (Object)parent);
        }
    }
}

