/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef.javaparser;

import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import io.sitoolkit.cv.core.domain.classdef.TypeDef;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TypeProcessor.class);

    public static List<TypeDef> collectParamTypes(ResolvedMethodDeclaration declaredMethod) {
        return IntStream.range(0, declaredMethod.getNumberOfParams()).mapToObj(arg_0 -> ((ResolvedMethodDeclaration)declaredMethod).getParam(arg_0)).map(TypeProcessor::createTypeDef).collect(Collectors.toList());
    }

    public static TypeDef createTypeDef(ResolvedParameterDeclaration param) {
        TypeDef typeDef = TypeProcessor.createTypeDef(param.getType());
        typeDef.setVariable(param.getName());
        return typeDef;
    }

    public static TypeDef createTypeDef(ResolvedType type) {
        TypeDef typeDef = new TypeDef();
        if (type.isPrimitive()) {
            typeDef.setName(type.asPrimitive().name().toLowerCase());
        } else if (type.isVoid()) {
            typeDef.setName("void");
        } else if (type.isArray()) {
            typeDef.setName(type.asArrayType().describe());
        } else if (type.isTypeVariable()) {
            typeDef.setName(type.asTypeVariable().qualifiedName());
        } else if (type.isReference()) {
            try {
                ResolvedReferenceType rType = type.asReferenceType();
                typeDef.setName(rType.getQualifiedName());
                List<TypeDef> typeList = rType.getTypeParametersMap().stream().map(pair -> (ResolvedType)pair.b).map(TypeProcessor::createTypeDef).collect(Collectors.toList());
                typeDef.setTypeParamList(typeList);
            }
            catch (UnsupportedOperationException e) {
                log.debug("Unsolved type:{}, {}", (Object)type, (Object)e.getMessage());
                typeDef.setName(type.toString());
            }
        } else {
            typeDef.setName(type.toString());
        }
        return typeDef;
    }
}

