/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef.javaparser;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.ForeachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import io.sitoolkit.cv.core.domain.classdef.javaparser.DeclationProcessor;
import io.sitoolkit.cv.core.domain.classdef.javaparser.MethodResolver;
import io.sitoolkit.cv.core.domain.classdef.javaparser.VisitContext;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementVisitor
extends VoidVisitorAdapter<VisitContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatementVisitor.class);
    private static final Pattern STREAM_METHOD_PATTERN = Pattern.compile("java\\.util\\.stream\\.Stream\\..*");
    private final MethodResolver methodResolver;

    public static StatementVisitor build(JavaParserFacade jpf) {
        MethodResolver methodResolver = new MethodResolver(jpf);
        return new StatementVisitor(methodResolver);
    }

    public void visit(ForeachStmt foreachStmt, VisitContext context) {
        String scope = this.buildForLoopScope((Node)foreachStmt, " : ", "for (", ")");
        context.startLoopContext((Node)foreachStmt, scope);
        super.visit(foreachStmt, (Object)context);
        context.endContext();
    }

    public void visit(ForStmt forStmt, VisitContext context) {
        String scope = this.buildForLoopScope((Node)forStmt, "; ", "for (", ")");
        context.startLoopContext((Node)forStmt, scope);
        super.visit(forStmt, (Object)context);
        context.endContext();
    }

    public void visit(IfStmt ifStmt, VisitContext context) {
        log.trace("{}Visiting IfStmt:{}", (Object)context.getLogLeftPadding(), (Object)ifStmt);
        if (this.isIfElse((Statement)ifStmt)) {
            this.addConditionalStatement(ifStmt, context, false);
            super.visit(ifStmt, (Object)context);
            context.endContext();
        } else {
            context.startBranchContext(ifStmt);
            this.addConditionalStatement(ifStmt, context, true);
            super.visit(ifStmt, (Object)context);
            context.endContext();
            context.endContext();
        }
    }

    public void visit(WhileStmt whileStmt, VisitContext context) {
        super.visit(whileStmt, (Object)context);
    }

    public void visit(MethodCallExpr methodCallExpr, VisitContext context) {
        if (this.isInIfCondition((Node)methodCallExpr)) {
            log.debug("{}Method calls in if (...) are not supported (not drawn in sequence diagram) : \"{}\"", (Object)context.getLogLeftPadding(), (Object)methodCallExpr);
            super.visit(methodCallExpr, (Object)context);
            return;
        }
        log.trace("{}Visiting MethodCallExpr:{}", (Object)context.getLogLeftPadding(), (Object)methodCallExpr);
        if (this.isStreamMethod(methodCallExpr)) {
            String scope = this.buildStreamLoopScope(methodCallExpr);
            context.startLoopContext((Node)methodCallExpr, scope);
            super.visit(methodCallExpr, (Object)context);
            context.endContext();
        } else {
            super.visit(methodCallExpr, (Object)context);
            if (!this.isStreamStartMethod(methodCallExpr)) {
                this.methodResolver.resolve((Node)methodCallExpr).map(resolvedMethodDeclaration -> DeclationProcessor.createMethodCall(resolvedMethodDeclaration, methodCallExpr.getParentNode())).ifPresent(context::addMethodCall);
            }
        }
    }

    public void visit(LambdaExpr lambdaExpr, VisitContext context) {
        if (context.isInLoop()) {
            super.visit(lambdaExpr, (Object)context);
        }
    }

    public void visit(MethodReferenceExpr methodReferenceExpr, VisitContext context) {
        if (context.isInLoop()) {
            super.visit(methodReferenceExpr, (Object)context);
            this.methodResolver.resolve((Node)methodReferenceExpr).map(m -> DeclationProcessor.createMethodCall(m, Optional.empty())).ifPresent(context::addMethodCall);
        }
    }

    public void visit(BlockStmt blockStmt, VisitContext context) {
        if (this.isIfElse((Statement)blockStmt)) {
            this.addElseConditionalStatement((Statement)blockStmt, context);
            super.visit(blockStmt, (Object)context);
            context.endContext();
        } else if (this.isFinally((Statement)blockStmt)) {
            context.startFinallyContext((Statement)blockStmt);
            super.visit(blockStmt, (Object)context);
            context.endContext();
        } else {
            super.visit(blockStmt, (Object)context);
        }
    }

    public void visit(ExpressionStmt expressionStmt, VisitContext context) {
        if (this.isIfElse((Statement)expressionStmt)) {
            this.addElseConditionalStatement((Statement)expressionStmt, context);
            super.visit(expressionStmt, (Object)context);
            context.endContext();
        } else {
            super.visit(expressionStmt, (Object)context);
        }
    }

    public void visit(TryStmt tryStmt, VisitContext context) {
        context.startTryContext(tryStmt);
        super.visit(tryStmt, (Object)context);
        context.endContext();
    }

    public void visit(CatchClause catchClause, VisitContext context) {
        context.startCatchContext(catchClause, catchClause.getParameter().getType().getTokenRange().map(Object::toString).orElse(""));
        super.visit(catchClause, (Object)context);
        context.endContext();
    }

    boolean isFinally(Statement stmt) {
        Optional<TryStmt> parentTry = stmt.getParentNode().filter(TryStmt.class::isInstance).map(TryStmt.class::cast);
        if (parentTry.isPresent()) {
            Optional finallyStmt = parentTry.get().getFinallyBlock();
            return finallyStmt.isPresent() && finallyStmt.get() == stmt;
        }
        return false;
    }

    boolean isIfElse(Statement stmt) {
        Optional<IfStmt> parentIf = stmt.getParentNode().filter(IfStmt.class::isInstance).map(IfStmt.class::cast);
        if (parentIf.isPresent()) {
            Optional elseStmt = parentIf.get().getElseStmt();
            return elseStmt.isPresent() && elseStmt.get() == stmt;
        }
        return false;
    }

    boolean isInIfCondition(Node node) {
        Optional parentNode = node.getParentNode();
        if (parentNode.isPresent()) {
            Node parent = (Node)parentNode.get();
            if (parent instanceof IfStmt) {
                return node == ((IfStmt)parent).getCondition();
            }
            return this.isInIfCondition(parent);
        }
        return false;
    }

    boolean isStreamMethod(MethodCallExpr n) {
        return this.methodResolver.resolve((Node)n).map(method -> STREAM_METHOD_PATTERN.matcher(method.getQualifiedName()).matches()).orElse(false);
    }

    boolean isStreamStartMethod(MethodCallExpr n) {
        return this.methodResolver.resolve((Node)n).map(method -> "java.util.Collection.stream".equals(method.getQualifiedName())).orElse(false);
    }

    String buildStreamLoopScope(MethodCallExpr n) {
        return n.getScope().filter(s -> s.isMethodCallExpr() && this.isStreamMethod(n)).map(scope -> this.buildStreamLoopScope(scope.asMethodCallExpr())).orElseGet(() -> n.getTokenRange().map(Object::toString).orElse(""));
    }

    String buildForLoopScope(Node node, String delimiter, String prefix, String suffix) {
        return node.getChildNodes().stream().filter(c -> !(c instanceof BlockStmt)).map(Object::toString).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    void addConditionalStatement(IfStmt parentIf, VisitContext context, boolean isFirst) {
        String condition = parentIf.getCondition().getTokenRange().map(Object::toString).orElse("");
        context.addConditionalContext((Statement)parentIf, condition, isFirst);
    }

    void addElseConditionalStatement(Statement stmt, VisitContext context) {
        context.addConditionalContext(stmt, "else", false);
    }

    @Generated
    private StatementVisitor(MethodResolver methodResolver) {
        this.methodResolver = methodResolver;
    }
}

