/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef.javaparser;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MethodReferenceResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MethodReferenceResolver.class);
    private final JavaParserFacade jpf;

    public Optional<ResolvedMethodDeclaration> resolve(MethodReferenceExpr methodRefExpr) {
        Expression scope = methodRefExpr.getScope();
        String identifier = methodRefExpr.getIdentifier();
        Optional<ResolvedMethodDeclaration> result = this.findMethodDeclation(this.resolveMethodsFromTypeOf(scope), identifier);
        if (result.isPresent()) {
            log.debug("method reference solved: '{}' -> {} ", (Object)methodRefExpr, (Object)result.get());
        } else {
            log.debug("method reference unsolved: '{}' ", (Object)methodRefExpr);
        }
        return result;
    }

    List<ResolvedMethodDeclaration> resolveMethodsFromTypeOf(Expression exp) {
        if (exp instanceof TypeExpr) {
            return this.resolveType((TypeExpr)exp).map(ResolvedReferenceType::getAllMethods).orElse(Collections.emptyList());
        }
        if (exp instanceof ThisExpr) {
            return this.resolveTypeDeclaration((ThisExpr)exp).map(declatrion -> declatrion.getAllMethods().stream().map(MethodUsage::getDeclaration).collect(Collectors.toList())).orElse(Collections.emptyList());
        }
        if (exp instanceof ClassExpr) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    Optional<ResolvedReferenceType> resolveType(TypeExpr exp) {
        Type type = exp.getType();
        try {
            ResolvedType rt = this.jpf.convertToUsage(type);
            if (rt.isReferenceType()) {
                log.debug("Solved as Type : {}", (Object)exp);
                return Optional.of(rt.asReferenceType());
            }
            log.debug("Unsolved as Type : {}", (Object)exp);
        }
        catch (Exception e) {
            log.debug("Unsolved as Type : {}, {}", (Object)exp, (Object)e.getMessage());
        }
        try {
            SymbolReference sr = this.jpf.getSymbolSolver().solveSymbol(exp.toString(), (Node)exp);
            if (sr.isSolved()) {
                log.debug("Solved as Symbol : {}", (Object)exp);
                ResolvedType rt = ((ResolvedValueDeclaration)sr.getCorrespondingDeclaration()).getType();
                if (rt.isReferenceType()) {
                    log.debug("type of Symbol '{}' : {}", (Object)exp, (Object)rt);
                    return Optional.of(rt.asReferenceType());
                }
            } else {
                log.debug("Unsolved as Symbol : {}", (Object)exp);
            }
        }
        catch (Exception e) {
            log.debug("Unsolved as Symbol : {}, {}", (Object)exp, (Object)e.getMessage());
        }
        return Optional.empty();
    }

    Optional<ResolvedReferenceTypeDeclaration> resolveTypeDeclaration(ThisExpr exp) {
        try {
            SymbolReference sr = this.jpf.solve(exp);
            if (sr.isSolved()) {
                ResolvedReferenceTypeDeclaration rrtd = ((ResolvedTypeDeclaration)sr.getCorrespondingDeclaration()).asReferenceType();
                log.debug("Solved thisExpr : {}", (Object)exp, (Object)rrtd);
                return Optional.of(rrtd);
            }
            log.debug("Unsolved thisExpr : {}", (Object)exp);
        }
        catch (Exception e) {
            log.debug("Unsolved thisExpr : {}, {}", (Object)exp, (Object)e.getMessage());
        }
        return Optional.empty();
    }

    Optional<ResolvedMethodDeclaration> findMethodDeclation(List<ResolvedMethodDeclaration> methods, String methodIdentifier) {
        List found = methods.stream().filter(m -> m.getName().equals(methodIdentifier)).collect(Collectors.toList());
        if (found.size() == 1) {
            ResolvedMethodDeclaration rmd = (ResolvedMethodDeclaration)found.get(0);
            return Optional.of(rmd);
        }
        if (found.size() > 1) {
            log.debug("Coudn't specify method reference:'{}' because type has overloaded methods: {}", (Object)methodIdentifier, found);
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Generated
    public MethodReferenceResolver(JavaParserFacade jpf) {
        this.jpf = jpf;
    }
}

