/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef.javaparser;

import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import io.sitoolkit.cv.core.domain.project.Project;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaParserFacadeBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaParserFacadeBuilder.class);

    private JavaParserFacadeBuilder() {
    }

    public static JavaParserFacade build(Project project) {
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)new ReflectionTypeSolver());
        project.getAllPreProcessedDirs().stream().forEach(srcDir -> combinedTypeSolver.add((TypeSolver)new JavaParserTypeSolver(srcDir.toFile())));
        Set<Path> classpaths = project.getAllClasspaths();
        log.info("Adding classpaths for JavaParser:{}", classpaths);
        classpaths.stream().map(Path::toAbsolutePath).map(Path::toString).filter(path -> path.endsWith(".jar")).forEach(str -> {
            try {
                combinedTypeSolver.add((TypeSolver)JarTypeSolver.getJarTypeSolver((String)str));
            }
            catch (IOException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        });
        return JavaParserFacade.get((TypeSolver)combinedTypeSolver);
    }
}

