/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef.javaparser;

import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import lombok.Generated;

public class ClassDirTypeSolver
implements TypeSolver {
    private static ClassDirTypeSolver instance;
    private TypeSolver parent;
    private Map<String, Path> classFileMap = new HashMap<String, Path>();
    private ClassPool classPool = new ClassPool(false);

    public static synchronized ClassDirTypeSolver get(Path classDir) {
        if (instance == null) {
            instance = new ClassDirTypeSolver();
        }
        instance.addClassDir(classDir);
        return instance;
    }

    private void addClassDir(Path classDir) {
        try {
            this.classPool.appendClassPath(classDir.toString());
            this.classPool.appendSystemPath();
            Files.walk(classDir, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".class")).forEach(path -> this.classFileMap.put(this.classFilePathToClassName(classDir, (Path)path), (Path)path));
        }
        catch (IOException | NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String classFilePathToClassName(Path classDir, Path classFilePath) {
        String classFilePathStr = classDir.relativize(classFilePath).toString();
        if (!classFilePathStr.endsWith(".class")) {
            throw new IllegalStateException();
        }
        String className = classFilePathStr.substring(0, classFilePathStr.length() - ".class".length());
        className = className.replace('/', '.');
        className = className.replace('$', '.');
        return className;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        try {
            Path classFilePath = this.classFileMap.get(name);
            if (classFilePath == null) return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
            try (InputStream is = Files.newInputStream(classFilePath, new OpenOption[0]);){
                CtClass ctClass = this.classPool.makeClass(is);
                SymbolReference symbolReference = SymbolReference.solved((ResolvedDeclaration)JavassistFactory.toTypeDeclaration((CtClass)ctClass, (TypeSolver)this.getRoot()));
                return symbolReference;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public TypeSolver getParent() {
        return this.parent;
    }

    @Generated
    public void setParent(TypeSolver parent) {
        this.parent = parent;
    }
}

