/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.app.report;

import io.sitoolkit.cv.core.app.crud.CrudService;
import io.sitoolkit.cv.core.app.designdoc.DesignDocService;
import io.sitoolkit.cv.core.app.functionmodel.FunctionModelService;
import io.sitoolkit.cv.core.domain.crud.CrudMatrix;
import io.sitoolkit.cv.core.domain.functionmodel.FunctionModel;
import io.sitoolkit.cv.core.domain.menu.MenuItem;
import io.sitoolkit.cv.core.domain.project.ProjectManager;
import io.sitoolkit.cv.core.domain.report.Report;
import io.sitoolkit.cv.core.domain.report.ReportWriter;
import io.sitoolkit.cv.core.domain.report.crud.CrudReportProcessor;
import io.sitoolkit.cv.core.domain.report.designdoc.DesignDocReportProcessor;
import io.sitoolkit.cv.core.domain.report.functionmodel.FunctionModelReportProcessor;
import java.util.List;
import lombok.Generated;

public class ReportService {
    private FunctionModelReportProcessor functionModelReportProcessor;
    private DesignDocReportProcessor designDocReportProcessor;
    private CrudReportProcessor crudReportProcessor;
    private ReportWriter reportWriter;
    private FunctionModelService functionModelService;
    private DesignDocService designDocService;
    private CrudService crudService;
    private ProjectManager projectManager;

    public void export() {
        this.reportWriter.initDirectory(this.projectManager.getCurrentProject().getDir());
        List<FunctionModel> functionModels = this.functionModelService.getAll();
        List<Report<?>> reports = this.functionModelReportProcessor.process(functionModels);
        List<MenuItem> menuList = this.designDocService.buildMenu();
        reports.add(this.designDocReportProcessor.process(menuList));
        CrudMatrix crudMatrix = this.crudService.loadMatrix();
        reports.add(this.crudReportProcessor.process(crudMatrix));
        this.reportWriter.write(this.projectManager.getCurrentProject().getDir(), reports);
    }

    @Generated
    public ReportService(FunctionModelReportProcessor functionModelReportProcessor, DesignDocReportProcessor designDocReportProcessor, CrudReportProcessor crudReportProcessor, ReportWriter reportWriter, FunctionModelService functionModelService, DesignDocService designDocService, CrudService crudService, ProjectManager projectManager) {
        this.functionModelReportProcessor = functionModelReportProcessor;
        this.designDocReportProcessor = designDocReportProcessor;
        this.crudReportProcessor = crudReportProcessor;
        this.reportWriter = reportWriter;
        this.functionModelService = functionModelService;
        this.designDocService = designDocService;
        this.crudService = crudService;
        this.projectManager = projectManager;
    }
}

