/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.app.crud;

import io.sitoolkit.cv.core.app.functionmodel.FunctionModelService;
import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.crud.CrudMatrix;
import io.sitoolkit.cv.core.domain.crud.CrudProcessor;
import io.sitoolkit.cv.core.domain.crud.SqlPerMethod;
import io.sitoolkit.cv.core.domain.project.ProjectManager;
import io.sitoolkit.cv.core.infra.util.JsonUtils;
import java.io.File;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CrudService.class);
    @NonNull
    FunctionModelService functionModelService;
    @NonNull
    private CrudProcessor processor;
    @NonNull
    ProjectManager projectManager;

    public CrudMatrix loadMatrix() {
        Optional<CrudMatrix> crudMatrixOpt = JsonUtils.file2obj(this.projectManager.getCurrentProject().getCrudPath(), CrudMatrix.class);
        if (!crudMatrixOpt.isPresent()) {
            return this.generateMatrix();
        }
        CrudMatrix crudMatrix = crudMatrixOpt.get();
        File sqlLogFile = this.projectManager.getCurrentProject().getSqlLogPath().toFile();
        if (!sqlLogFile.exists() || crudMatrix.getSqlLogLastModified() == sqlLogFile.lastModified()) {
            return crudMatrix;
        }
        return this.generateMatrix();
    }

    public CrudMatrix generateMatrix() {
        Optional<List<SqlPerMethod>> sqlPerMethodList = this.projectManager.getSqlLog();
        if (!sqlPerMethodList.isPresent()) {
            log.warn("SQL log file not found. If you need a CRUD matrix, please run analyze-sql first.");
            return new CrudMatrix();
        }
        CrudMatrix methodCrud = this.processor.buildMatrix(sqlPerMethodList.get());
        List<ClassDef> entryPointClasses = this.functionModelService.getAllEntryPointClasses();
        CrudMatrix entryPointCrud = this.processor.adjustAxis(entryPointClasses, methodCrud);
        long lastModified = this.projectManager.getCurrentProject().getSqlLogPath().toFile().lastModified();
        entryPointCrud.setSqlLogLastModified(lastModified);
        JsonUtils.obj2file(entryPointCrud, this.projectManager.getCurrentProject().getCrudPath());
        return entryPointCrud;
    }

    public void analyzeSql() {
        this.projectManager.generateSqlLog();
    }

    @Generated
    public CrudService(@NonNull FunctionModelService functionModelService, @NonNull CrudProcessor processor, @NonNull ProjectManager projectManager) {
        if (functionModelService == null) {
            throw new NullPointerException("functionModelService is marked @NonNull but is null");
        }
        if (processor == null) {
            throw new NullPointerException("processor is marked @NonNull but is null");
        }
        if (projectManager == null) {
            throw new NullPointerException("projectManager is marked @NonNull but is null");
        }
        this.functionModelService = functionModelService;
        this.processor = processor;
        this.projectManager = projectManager;
    }
}

