/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.app.config;

import io.sitoolkit.cv.core.app.crud.CrudService;
import io.sitoolkit.cv.core.app.designdoc.DesignDocService;
import io.sitoolkit.cv.core.app.functionmodel.FunctionModelService;
import io.sitoolkit.cv.core.app.report.ReportService;
import io.sitoolkit.cv.core.domain.classdef.ClassDefRepositoryMemImpl;
import io.sitoolkit.cv.core.domain.classdef.javaparser.ClassDefReaderJavaParserImpl;
import io.sitoolkit.cv.core.domain.crud.CrudProcessor;
import io.sitoolkit.cv.core.domain.crud.jsqlparser.CrudFinderJsqlparserImpl;
import io.sitoolkit.cv.core.domain.designdoc.DesignDocMenuBuilder;
import io.sitoolkit.cv.core.domain.project.ProjectManager;
import io.sitoolkit.cv.core.domain.project.ProjectReader;
import io.sitoolkit.cv.core.domain.project.analyze.SqlLogProcessor;
import io.sitoolkit.cv.core.domain.project.gradle.GradleProjectReader;
import io.sitoolkit.cv.core.domain.project.maven.MavenProjectReader;
import io.sitoolkit.cv.core.domain.report.ReportWriter;
import io.sitoolkit.cv.core.domain.report.crud.CrudReportProcessor;
import io.sitoolkit.cv.core.domain.report.designdoc.DesignDocReportProcessor;
import io.sitoolkit.cv.core.domain.report.functionmodel.FunctionModelReportProcessor;
import io.sitoolkit.cv.core.domain.uml.ClassDiagramProcessor;
import io.sitoolkit.cv.core.domain.uml.SequenceDiagramProcessor;
import io.sitoolkit.cv.core.domain.uml.plantuml.ClassDiagramWriterPlantUmlImpl;
import io.sitoolkit.cv.core.domain.uml.plantuml.PlantUmlWriter;
import io.sitoolkit.cv.core.domain.uml.plantuml.SequenceDiagramWriterPlantUmlImpl;
import io.sitoolkit.cv.core.infra.config.SitCvConfig;
import io.sitoolkit.cv.core.infra.config.SitCvConfigReader;
import io.sitoolkit.cv.core.infra.graphviz.GraphvizManager;
import io.sitoolkit.cv.core.infra.watcher.FileInputSourceWatcher;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceFactory.class);
    private FunctionModelService functionModelService;
    private DesignDocService designDocService;
    private CrudService crudService;
    private ReportService reportService;
    private ProjectManager projectManager;

    private ServiceFactory() {
    }

    public static ServiceFactory create(Path projectDir) {
        return new ServiceFactory().createServices(projectDir);
    }

    public static ServiceFactory createAndInitialize(Path projectDir) {
        return new ServiceFactory().createServices(projectDir).initialize();
    }

    public ServiceFactory initialize() {
        try {
            this.functionModelService.analyze();
        }
        catch (Exception e) {
            log.error("Exception initializing Code Visualizer", (Throwable)e);
        }
        return this;
    }

    protected ServiceFactory createServices(Path projectDir) {
        SitCvConfigReader configReader = new SitCvConfigReader();
        SitCvConfig config = configReader.read(projectDir);
        this.projectManager = this.createProjectManager(config);
        this.projectManager.load(projectDir);
        this.functionModelService = this.createFunctionModelService(config, configReader, this.projectManager);
        this.designDocService = this.createDesignDocService(this.functionModelService);
        this.crudService = this.createCrudService(this.functionModelService, this.projectManager);
        this.reportService = this.createReportService(this.functionModelService, this.designDocService, this.crudService, this.projectManager);
        return this;
    }

    protected ProjectManager createProjectManager(SitCvConfig config) {
        SqlLogProcessor sqlLogProcessor = new SqlLogProcessor();
        List<ProjectReader> readers = Arrays.asList(new MavenProjectReader(sqlLogProcessor), new GradleProjectReader(sqlLogProcessor));
        return new ProjectManager(readers, config);
    }

    protected FunctionModelService createFunctionModelService(SitCvConfig config, SitCvConfigReader configReader, ProjectManager projectManager) {
        ClassDefRepositoryMemImpl classDefRepository = new ClassDefRepositoryMemImpl(config);
        ClassDefReaderJavaParserImpl classDefReader = new ClassDefReaderJavaParserImpl(classDefRepository, projectManager, config);
        SequenceDiagramProcessor sequenceProcessor = new SequenceDiagramProcessor(config);
        ClassDiagramProcessor classProcessor = new ClassDiagramProcessor();
        GraphvizManager.initialize();
        PlantUmlWriter plantumlWriter = new PlantUmlWriter();
        SequenceDiagramWriterPlantUmlImpl sequenceWriter = new SequenceDiagramWriterPlantUmlImpl(plantumlWriter);
        ClassDiagramWriterPlantUmlImpl classWriter = new ClassDiagramWriterPlantUmlImpl(plantumlWriter);
        FileInputSourceWatcher watcher = new FileInputSourceWatcher();
        return new FunctionModelService(classDefReader, sequenceProcessor, classProcessor, sequenceWriter, classWriter, classDefRepository, watcher, projectManager, configReader);
    }

    protected DesignDocService createDesignDocService(FunctionModelService functionModelService) {
        DesignDocMenuBuilder menuBuilder = new DesignDocMenuBuilder();
        return new DesignDocService(functionModelService, menuBuilder);
    }

    protected CrudService createCrudService(FunctionModelService functionModelService, ProjectManager projectManager) {
        CrudFinderJsqlparserImpl crudFinder = new CrudFinderJsqlparserImpl();
        CrudProcessor crudProcessor = new CrudProcessor(crudFinder);
        return new CrudService(functionModelService, crudProcessor, projectManager);
    }

    protected ReportService createReportService(FunctionModelService functionModelService, DesignDocService designDocService, CrudService crudService, ProjectManager projectManager) {
        FunctionModelReportProcessor functionModelReportProcessor = new FunctionModelReportProcessor();
        DesignDocReportProcessor designDocReportProcessor = new DesignDocReportProcessor();
        CrudReportProcessor crudReportProcessor = new CrudReportProcessor();
        ReportWriter reportWriter = new ReportWriter();
        return new ReportService(functionModelReportProcessor, designDocReportProcessor, crudReportProcessor, reportWriter, functionModelService, designDocService, crudService, projectManager);
    }

    @Generated
    public FunctionModelService getFunctionModelService() {
        return this.functionModelService;
    }

    @Generated
    public DesignDocService getDesignDocService() {
        return this.designDocService;
    }

    @Generated
    public CrudService getCrudService() {
        return this.crudService;
    }

    @Generated
    public ReportService getReportService() {
        return this.reportService;
    }

    @Generated
    public ProjectManager getProjectManager() {
        return this.projectManager;
    }
}

