/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.watcher;

import io.sitoolkit.cv.core.infra.watcher.ContinuousGeneratable;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputSourceWatcher {
    private static final Logger log = LoggerFactory.getLogger(InputSourceWatcher.class);
    private boolean isContinue = false;

    public void watch(String inputSource) {
        if (!this.isContinue()) {
            return;
        }
        this.watchInputSource(inputSource);
    }

    public void start(final ContinuousGeneratable cg) {
        if (!this.isContinue()) {
            return;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                while (InputSourceWatcher.this.isContinue()) {
                    Set<String> inputSources = InputSourceWatcher.this.watching();
                    log.info("Detected input source change {}", inputSources);
                    cg.regenerate(inputSources);
                }
            }
        });
    }

    public boolean isContinue() {
        return this.isContinue;
    }

    public void setContinue(boolean isContinue) {
        this.isContinue = isContinue;
    }

    protected abstract void watchInputSource(String var1);

    protected abstract Set<String> watching();

    protected abstract void end(ContinuousGeneratable var1);
}

