/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.watcher;

import io.sitoolkit.cv.core.infra.watcher.ContinuousGeneratable;
import io.sitoolkit.cv.core.infra.watcher.InputSourceWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInputSourceWatcher
extends InputSourceWatcher {
    private static final Logger log = LoggerFactory.getLogger(FileInputSourceWatcher.class);
    private WatchService watcher;
    private final Set<String> watchingDirSet = new HashSet<String>();
    private final Map<String, InputSource> watchingFileMap = new HashMap<String, InputSource>();
    private final Map<WatchKey, Path> pathMap = new HashMap<WatchKey, Path>();

    @Override
    public void watchInputSource(String inputSource) {
        File dir;
        File file = new File(inputSource);
        if (!file.exists()) {
            log.warn("File not found {}", (Object)file.getAbsolutePath());
            return;
        }
        if (this.watchingFileMap.containsKey(file.getAbsolutePath())) {
            return;
        }
        log.info("Start to watch {}", (Object)file.getAbsolutePath());
        this.watchingFileMap.put(file.getAbsolutePath(), new InputSource(inputSource, file.lastModified()));
        File file2 = dir = file.isFile() ? file.getParentFile() : file;
        if (file.isFile()) {
            if (this.watchingDirSet.contains(dir.getAbsolutePath())) {
                return;
            }
            log.info("Start to watch {}", (Object)dir.getAbsolutePath());
            this.watchingDirSet.add(dir.getAbsolutePath());
        }
        Path dirPath = dir.toPath();
        try {
            if (this.watcher == null) {
                this.watcher = FileSystems.getDefault().newWatchService();
            }
            WatchKey watchKey = dirPath.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
            this.pathMap.put(watchKey, dirPath);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Set<String> watching() {
        WatchKey watchKey;
        try {
            watchKey = this.watcher.take();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (ClosedWatchServiceException e) {
            if (this.isContinue()) {
                throw new IllegalStateException(e);
            }
            return Collections.emptySet();
        }
        HashSet<String> inputSources = new HashSet<String>();
        for (WatchEvent<?> event : watchKey.pollEvents()) {
            Path dir = this.pathMap.get(watchKey);
            File changedFile = dir.resolve((Path)event.context()).toFile();
            InputSource inputSource = this.watchingFileMap.get(changedFile.getAbsolutePath());
            if (inputSource == null || inputSource.lastModified == changedFile.lastModified()) continue;
            inputSources.add(inputSource.name);
            inputSource.lastModified = changedFile.lastModified();
        }
        watchKey.reset();
        return inputSources;
    }

    @Override
    protected void end(ContinuousGeneratable cg) {
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            log.warn("Exception when watcher close", (Throwable)e);
        }
        cg.regenerate(this.watchingFileMap.values().stream().map(InputSource::getName).collect(Collectors.toSet()));
    }

    class InputSource {
        String name;
        long lastModified;

        InputSource(String name, long lastModified) {
            this.name = name;
            this.lastModified = lastModified;
        }

        private InputSource() {
        }

        public String getName() {
            return this.name;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputSource)) {
                return false;
            }
            InputSource other = (InputSource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getLastModified() == other.getLastModified();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputSource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $lastModified = this.getLastModified();
            result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
            return result;
        }

        public String toString() {
            return "FileInputSourceWatcher.InputSource(name=" + this.getName() + ", lastModified=" + this.getLastModified() + ")";
        }
    }
}

