/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.graphviz;

import io.sitoolkit.cv.core.infra.SitRepository;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ZipUtil;

public class GraphvizManager {
    private static final Logger log = LoggerFactory.getLogger(GraphvizManager.class);
    private String winGraphvizDownloadUrl;
    private String winGraphvizInstallFile;

    private Path getGraphvizPath() {
        return SitRepository.getRepositoryPath().resolve("graphviz");
    }

    public Path getBinaryPath() {
        return this.getGraphvizPath().resolve("release/bin/dot.exe");
    }

    @PostConstruct
    public void init() {
        if (SystemUtils.IS_OS_WINDOWS) {
            this.loadProperties();
            this.checkBinary();
        }
    }

    private void loadProperties() {
        ResourceBundle rb = ResourceBundle.getBundle("graphviz");
        this.winGraphvizDownloadUrl = rb.getString("win.graphviz.downloadUrl");
        this.winGraphvizInstallFile = rb.getString("win.graphviz.installFile");
    }

    private void checkBinary() {
        Path binaryPath = this.getBinaryPath();
        if (Files.exists(binaryPath, new LinkOption[0])) {
            log.info("Executable Graphviz found in SitRepository : {}", (Object)binaryPath);
        } else {
            log.info("Graphviz not found in SitRepository");
            this.installGraphviz();
        }
    }

    private void installGraphviz() {
        this.prepareDirectory();
        this.installGraphvizWindows();
    }

    private void installGraphvizWindows() {
        log.info("Installing Graphviz...");
        this.downloadWindowsBinary();
        this.extractBinary();
        log.info("Finished Installing Graphviz");
    }

    private void prepareDirectory() {
        if (!Files.exists(this.getGraphvizPath(), new LinkOption[0])) {
            try {
                Files.createDirectories(this.getGraphvizPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void downloadWindowsBinary() {
        Path zipFile = this.getGraphvizPath().resolve(this.winGraphvizInstallFile);
        if (Files.exists(zipFile, new LinkOption[0])) {
            log.info("zipFile exists :{}", (Object)zipFile.toString());
        } else {
            try {
                URL url = new URL(this.winGraphvizDownloadUrl);
                log.info("downloading zipFile from '{}' ... ", (Object)url);
                FileUtils.copyURLToFile((URL)url, (File)zipFile.toFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void extractBinary() {
        Path zipFile = this.getGraphvizPath().resolve(this.winGraphvizInstallFile);
        log.info("extracting zipfile '{}' ... ", (Object)zipFile);
        ZipUtil.unpack((File)zipFile.toFile(), (File)this.getGraphvizPath().toFile());
        if (!Files.exists(this.getBinaryPath(), new LinkOption[0])) {
            log.error("graphviz executable not found at '{}' ", (Object)this.getBinaryPath().toAbsolutePath());
            throw new IllegalStateException("graphviz executable not found at " + this.getBinaryPath().toAbsolutePath());
        }
    }
}

