/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.uml.plantuml;

import io.sitoolkit.cv.core.domain.designdoc.Diagram;
import io.sitoolkit.cv.core.domain.uml.DiagramWriter;
import io.sitoolkit.cv.core.domain.uml.LifeLineDef;
import io.sitoolkit.cv.core.domain.uml.MessageDef;
import io.sitoolkit.cv.core.domain.uml.SequenceDiagram;
import io.sitoolkit.cv.core.domain.uml.plantuml.PlantUmlWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public class SequenceDiagramWriterPlantUmlImpl
implements DiagramWriter<SequenceDiagram> {
    @Resource
    PlantUmlWriter plantumlWriter;

    public List<String> write(List<SequenceDiagram> diagrams) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("@startuml");
        lines.addAll(diagrams.stream().map(diagram -> this.lifeline2str(diagram.getEntryLifeLine())).flatMap(Collection::stream).collect(Collectors.toList()));
        lines.add("@enduml");
        return lines;
    }

    @Override
    public Diagram write(SequenceDiagram diagram) {
        return this.plantumlWriter.createDiagram(diagram, this::serialize);
    }

    public String serialize(SequenceDiagram diagram) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("@startuml");
        lines.addAll(this.lifeline2str(diagram.getEntryLifeLine()));
        lines.add("@enduml");
        return lines.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    private List<String> lifeline2str(LifeLineDef lifeLine) {
        return lifeLine.getMessages().stream().map(message -> this.message2str(lifeLine, (MessageDef)message)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<String> message2str(LifeLineDef lifeLine, MessageDef message) {
        LifeLineDef target = message.getTarget();
        List<String> list = this.lifeline2str(target);
        list.add(0, lifeLine.getObjectName() + " -> " + target.getObjectName() + " :" + message.getRequestName());
        if (!StringUtils.equals((CharSequence)message.getResponseName(), (CharSequence)"void")) {
            list.add(lifeLine.getObjectName() + " <-- " + target.getObjectName() + " :" + message.getResponseName());
        }
        return list;
    }

    public void writeToFile(List<SequenceDiagram> diagrams, Path filePath) {
        try {
            Files.write(filePath, this.write(diagrams), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

