/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.uml.plantuml;

import io.sitoolkit.cv.core.domain.designdoc.Diagram;
import io.sitoolkit.cv.core.domain.uml.DiagramModel;
import io.sitoolkit.cv.core.infra.graphviz.GraphvizManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import org.apache.commons.lang3.SystemUtils;

public class PlantUmlWriter {
    @Resource
    GraphvizManager graphvizManager;

    @PostConstruct
    public void init() {
        if (SystemUtils.IS_OS_WINDOWS) {
            String graphvizPath = this.graphvizManager.getBinaryPath().toAbsolutePath().toString();
            GraphvizUtils.setDotExecutable((String)graphvizPath);
        }
    }

    public <T extends DiagramModel> Diagram createDiagram(T model, Function<T, String> serializer) {
        Diagram diagram = new Diagram();
        diagram.setId(model.getId());
        diagram.setTags(model.getAllTags());
        SourceStringReader reader = new SourceStringReader(serializer.apply(model));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            reader.outputImage((OutputStream)baos, new FileFormatOption(FileFormat.PNG));
            diagram.setData(baos.toByteArray());
            return diagram;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

