/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.uml.plantuml;

import io.sitoolkit.cv.core.domain.classdef.ClassDefRepositoryMemImpl;
import io.sitoolkit.cv.core.domain.classdef.ClassDefRepositoryParam;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.classdef.javaparser.ClassDefReaderJavaParserImpl;
import io.sitoolkit.cv.core.domain.uml.ClassDiagramProcessor;
import io.sitoolkit.cv.core.domain.uml.LifeLineDef;
import io.sitoolkit.cv.core.domain.uml.SequenceDiagram;
import io.sitoolkit.cv.core.domain.uml.SequenceDiagramProcessor;
import io.sitoolkit.cv.core.domain.uml.plantuml.ClassDiagramWriterPlantUmlImpl;
import io.sitoolkit.cv.core.domain.uml.plantuml.SequenceDiagramWriterPlantUmlImpl;
import io.sitoolkit.cv.core.infra.config.Config;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;

public class DiagramTester {
    public static void main(String[] args) throws Exception {
        new DiagramTester().execute();
    }

    void execute() throws Exception {
        ClassDefRepositoryMemImpl repository = new ClassDefRepositoryMemImpl();
        Config config = new Config();
        ClassDefReaderJavaParserImpl reader = new ClassDefReaderJavaParserImpl(repository, config);
        ClassDefRepositoryParam param = new ClassDefRepositoryParam();
        param.getSrcDirs().add(Paths.get("../sample/src/test/java", new String[0]));
        reader.init(param);
        reader.readDir(Paths.get("../sample/src/test/java", new String[0]));
        MethodDef entryPoint = repository.findMethodByQualifiedSignature("sample.SequenceClass1.entryPoint()");
        this.outputImage(this.getSequenceDiagramUML(entryPoint), "sequence.png");
        this.outputImage(this.getClassDiagramUML(entryPoint), "class.png");
    }

    String getSequenceDiagramUML(MethodDef entryPoint) {
        SequenceDiagramWriterPlantUmlImpl writer = new SequenceDiagramWriterPlantUmlImpl();
        SequenceDiagramProcessor processor = new SequenceDiagramProcessor();
        LifeLineDef entryLifeLine = processor.process(entryPoint.getClassDef(), entryPoint);
        SequenceDiagram sd = SequenceDiagram.builder().entryLifeLine(entryLifeLine).build();
        return writer.serialize(sd);
    }

    String getClassDiagramUML(MethodDef entryPoint) {
        ClassDiagramWriterPlantUmlImpl writer = new ClassDiagramWriterPlantUmlImpl();
        ClassDiagramProcessor processor = new ClassDiagramProcessor();
        return writer.serialize(processor.process(entryPoint));
    }

    void outputImage(String uml, String fileName) throws IOException {
        SourceStringReader ssReader = new SourceStringReader(uml);
        FileOutputStream fos = new FileOutputStream(fileName);
        ssReader.outputImage((OutputStream)fos, new FileFormatOption(FileFormat.PNG));
    }
}

