/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.uml;

import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.classdef.MethodCallDef;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.classdef.filter.ClassDefFilter;
import io.sitoolkit.cv.core.domain.uml.LifeLineDef;
import io.sitoolkit.cv.core.domain.uml.MessageDef;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceDiagramProcessor {
    private static final Logger log = LoggerFactory.getLogger(SequenceDiagramProcessor.class);
    @Resource
    ClassDefFilter classFilter = new ClassDefFilter();

    public LifeLineDef process(ClassDef clazz, MethodDef method) {
        LifeLineDef lifeLine = new LifeLineDef();
        lifeLine.setSourceId(clazz.getSourceId());
        lifeLine.setEntryMessage(method.getQualifiedSignature());
        lifeLine.setObjectName(clazz.getName());
        lifeLine.setMessages(method.getMethodCalls().stream().map(this::methodCall2Message).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        log.debug("Add lifeline {} -> {}", (Object)clazz.getName(), (Object)lifeLine);
        return lifeLine;
    }

    Optional<MessageDef> methodCall2Message(MethodCallDef methodCall) {
        if (methodCall.getClassDef() == null) {
            return Optional.empty();
        }
        MethodDef methodImpl = this.detectMethodImplementation(methodCall);
        if (!this.classFilter.test(methodImpl.getClassDef())) {
            return Optional.empty();
        }
        MessageDef message = new MessageDef();
        message.setRequestName(methodImpl.getSignature());
        message.setTarget(this.process(methodImpl.getClassDef(), methodImpl));
        message.setResponseName(methodCall.getReturnType().toString());
        return Optional.of(message);
    }

    MethodDef detectMethodImplementation(MethodCallDef methodCall) {
        ClassDef classOrInterface = methodCall.getClassDef();
        if (classOrInterface != null && classOrInterface.isInterface()) {
            ClassDef interfaze = classOrInterface;
            Set<ClassDef> knownImplClasses = interfaze.getKnownImplClasses();
            log.debug("Interface {} has KnownImplements : {}", (Object)interfaze.getName(), knownImplClasses);
            if (knownImplClasses.size() == 1) {
                ClassDef onlyImpl = knownImplClasses.iterator().next();
                log.debug("{}'s the only knoun impl found : {} ", (Object)interfaze.getName(), (Object)onlyImpl.getName());
                Optional<MethodDef> methodImpl = this.findMethod(onlyImpl, methodCall.getSignature());
                if (methodImpl.isPresent()) {
                    return methodImpl.get();
                }
            }
        }
        return methodCall;
    }

    Optional<MethodDef> findMethod(ClassDef classDef, String signature) {
        log.debug("Finding '{}' from '{}'", (Object)signature, (Object)classDef.getName());
        Optional<MethodDef> foundMethod = classDef.getMethods().stream().filter(m -> StringUtils.equals((CharSequence)signature, (CharSequence)m.getSignature())).findFirst();
        if (foundMethod.isPresent()) {
            log.debug("Method found : {}", (Object)foundMethod.get().getQualifiedSignature());
        } else {
            log.debug("'{}' not found from '{}'", (Object)signature, (Object)classDef.getName());
        }
        return foundMethod;
    }
}

