/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef.javaparser;

import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import io.sitoolkit.cv.core.domain.classdef.MethodCallDef;
import io.sitoolkit.cv.core.domain.classdef.javaparser.TypeParser;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCallVisitor
extends VoidVisitorAdapter<List<MethodCallDef>> {
    private static final Logger log = LoggerFactory.getLogger(MethodCallVisitor.class);
    JavaParserFacade jpf;

    public void visit(MethodCallExpr methodCallExpr, List<MethodCallDef> methodCalls) {
        try {
            SymbolReference ref = this.jpf.solve(methodCallExpr);
            if (ref.isSolved()) {
                ResolvedMethodDeclaration rmd = (ResolvedMethodDeclaration)ref.getCorrespondingDeclaration();
                MethodCallDef methodCall = new MethodCallDef();
                methodCall.setSignature(rmd.getSignature());
                methodCall.setQualifiedSignature(rmd.getQualifiedSignature());
                methodCall.setName(rmd.getName());
                methodCall.setClassName(rmd.getClassName());
                methodCall.setPackageName(rmd.getPackageName());
                methodCall.setReturnType(TypeParser.getTypeDef(rmd.getReturnType()));
                methodCall.setParamTypes(TypeParser.getParamTypes(rmd));
                log.debug("Add method call : {}", (Object)methodCall);
                methodCalls.add(methodCall);
            } else {
                log.debug("Unsolved : {}", (Object)methodCallExpr);
            }
        }
        catch (Exception e) {
            log.debug("Unsolved:{}, {}", (Object)methodCallExpr, (Object)e);
        }
    }

    public MethodCallVisitor(JavaParserFacade jpf) {
        this.jpf = jpf;
    }
}

