/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef.javaparser;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.classdef.ClassDefReader;
import io.sitoolkit.cv.core.domain.classdef.ClassDefRepository;
import io.sitoolkit.cv.core.domain.classdef.ClassDefRepositoryParam;
import io.sitoolkit.cv.core.domain.classdef.ClassType;
import io.sitoolkit.cv.core.domain.classdef.FieldDef;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.classdef.javaparser.ClassDirTypeSolver;
import io.sitoolkit.cv.core.domain.classdef.javaparser.MethodCallVisitor;
import io.sitoolkit.cv.core.domain.classdef.javaparser.TypeParser;
import io.sitoolkit.cv.core.infra.config.Config;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDefReaderJavaParserImpl
implements ClassDefReader {
    private static final Logger log = LoggerFactory.getLogger(ClassDefReaderJavaParserImpl.class);
    private JavaParserFacade jpf;
    private MethodCallVisitor methodCallVisitor;
    @Resource
    ClassDefRepository reposiotry;
    @Resource
    Config config;
    private static final String[] ACTION_ANNOTATION_NAMES = new String[]{"RequestMapping", "PostMapping", "GetMapping"};

    public ClassDefReaderJavaParserImpl(ClassDefRepository reposiotry, Config config) {
        this.reposiotry = reposiotry;
        this.config = config;
    }

    @Override
    public void readDir(Path srcDir) {
        this.init(srcDir);
        try {
            Pattern p = Pattern.compile(this.config.getJavaFilePattern());
            List files = Files.walk(srcDir, new FileVisitOption[0]).filter(file -> p.matcher(file.toFile().getName()).matches()).collect(Collectors.toList());
            files.stream().forEach(javaFile -> {
                this.readJava((Path)javaFile).ifPresent(classDef -> this.reposiotry.save((ClassDef)classDef));
                int readCount = this.reposiotry.countClassDefs();
                if (readCount % 10 == 0) {
                    log.info("Processed java files : {} / {} ", (Object)readCount, (Object)files.size());
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.reposiotry.solveReferences();
    }

    @Override
    public void init(Path srcDir) {
        Path jarList;
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)new ReflectionTypeSolver());
        if (srcDir != null) {
            combinedTypeSolver.add((TypeSolver)new JavaParserTypeSolver(srcDir.toFile()));
        }
        if ((jarList = Paths.get(this.config.getJarList(), new String[0])).toFile().exists()) {
            try {
                String jarListStr = new String(Files.readAllBytes(jarList));
                for (String line : jarListStr.split(File.pathSeparator + "|" + System.lineSeparator())) {
                    try {
                        combinedTypeSolver.add((TypeSolver)JarTypeSolver.getJarTypeSolver((String)line));
                        log.info("jar is added. {}", (Object)line);
                    }
                    catch (IOException e) {
                        log.warn("warn ", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.jpf = JavaParserFacade.get((TypeSolver)combinedTypeSolver);
        this.methodCallVisitor = new MethodCallVisitor(this.jpf);
    }

    @Override
    public Optional<ClassDef> readJava(Path javaFile) {
        log.debug("Read java : {}", (Object)javaFile);
        try {
            CompilationUnit compilationUnit = JavaParser.parse((Path)javaFile);
            ClassDef classDef = new ClassDef();
            classDef.setSourceId(javaFile.toFile().getAbsolutePath());
            String typeName = (String)compilationUnit.getPrimaryTypeName().get();
            classDef.setName(typeName);
            classDef.setPkg(((PackageDeclaration)compilationUnit.getPackageDeclaration().get()).getNameAsString());
            compilationUnit.getClassByName(typeName).ifPresent(clazz -> {
                classDef.setType(ClassType.CLASS);
                classDef.setMethods(this.readMethodDefs((ClassOrInterfaceDeclaration)clazz));
                classDef.setFields(this.readFieldDefs((ClassOrInterfaceDeclaration)clazz));
                classDef.setImplInterfaces(this.readInterfaces((ClassOrInterfaceDeclaration)clazz));
                classDef.setAnnotations(this.readAnnotations((ClassOrInterfaceDeclaration)clazz));
            });
            compilationUnit.getInterfaceByName(typeName).ifPresent(interfaze -> {
                classDef.setType(ClassType.INTERFACE);
                classDef.setMethods(this.readMethodDefs((ClassOrInterfaceDeclaration)interfaze));
                classDef.setFields(this.readFieldDefs((ClassOrInterfaceDeclaration)interfaze));
                classDef.setAnnotations(this.readAnnotations((ClassOrInterfaceDeclaration)interfaze));
            });
            classDef.getMethods().stream().forEach(method -> method.setClassDef(classDef));
            log.debug("Read class : {}", (Object)classDef);
            return Optional.of(classDef);
        }
        catch (IOException e) {
            log.warn("IOException", (Throwable)e);
            return Optional.empty();
        }
    }

    private Set<String> readInterfaces(ClassOrInterfaceDeclaration typeDec) {
        Set<String> interfaces = new HashSet<String>();
        try {
            interfaces = this.jpf.getTypeDeclaration(typeDec).getAllAncestors().stream().map(ResolvedReferenceType::getTypeDeclaration).filter(ResolvedTypeDeclaration::isInterface).map(ResolvedTypeDeclaration::getQualifiedName).collect(Collectors.toSet());
            log.debug("{} implements interfaces: {}", (Object)typeDec.getNameAsString(), interfaces);
        }
        catch (Exception e) {
            log.debug("Unsolved : Ancestors of '{}', {}", (Object)typeDec.getName(), (Object)e);
        }
        return interfaces;
    }

    Set<String> readAnnotations(ClassOrInterfaceDeclaration typeDec) {
        Set<String> annotations = typeDec.getAnnotations().stream().map(NodeWithName::getNameAsString).collect(Collectors.toSet());
        log.debug("{} has annotations : {}", (Object)typeDec.getNameAsString(), annotations);
        return annotations;
    }

    List<MethodDef> readMethodDefs(ClassOrInterfaceDeclaration typeDec) {
        ArrayList<MethodDef> methodDefs = new ArrayList<MethodDef>();
        String classActionPath = this.getActionPath((NodeWithAnnotations<?>)typeDec);
        this.jpf.getTypeDeclaration(typeDec).getDeclaredMethods().forEach(declaredMethod -> {
            try {
                MethodDef methodDef = new MethodDef();
                methodDef.setPublic(declaredMethod.accessSpecifier() == AccessSpecifier.PUBLIC);
                methodDef.setName(declaredMethod.getName());
                methodDef.setSignature(declaredMethod.getSignature());
                methodDef.setQualifiedSignature(declaredMethod.getQualifiedSignature());
                methodDef.setReturnType(TypeParser.getTypeDef(declaredMethod.getReturnType()));
                methodDef.setParamTypes(TypeParser.getParamTypes(declaredMethod));
                methodDefs.add(methodDef);
                if (!typeDec.isInterface()) {
                    typeDec.getMethods().stream().forEach(method -> {
                        if (this.equalMethods((ResolvedMethodDeclaration)declaredMethod, (MethodDeclaration)method)) {
                            method.accept((VoidVisitor)this.methodCallVisitor, methodDef.getMethodCalls());
                            methodDef.setActionPath(classActionPath + this.getActionPath((NodeWithAnnotations<?>)method));
                        }
                    });
                }
                log.debug("Add method declaration : {}", (Object)methodDef);
            }
            catch (Exception e) {
                log.debug("Unsolved: '{}()' in '{}', {}", new Object[]{declaredMethod.getName(), typeDec.getName(), e});
            }
        });
        return methodDefs;
    }

    boolean equalMethods(ResolvedMethodDeclaration m1, MethodDeclaration m2) {
        if (!m1.getName().equals(m2.getNameAsString())) {
            return false;
        }
        if (m1.getNumberOfParams() != m2.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < m1.getNumberOfParams(); ++i) {
            ResolvedParameterDeclaration p1 = m1.getParam(i);
            Parameter p2 = m2.getParameter(i);
            if (p1.getName().endsWith(p2.getNameAsString())) continue;
            return false;
        }
        return true;
    }

    String getActionPath(NodeWithAnnotations<?> nwa) {
        for (String annotationName : ACTION_ANNOTATION_NAMES) {
            Optional annotation = nwa.getAnnotationByName(annotationName);
            if (!annotation.isPresent()) continue;
            return this.retrive((AnnotationExpr)annotation.get());
        }
        return "";
    }

    String retrive(AnnotationExpr annotation) {
        StringBuilder actionPath = new StringBuilder();
        annotation.toNormalAnnotationExpr().ifPresent(nae -> nae.getPairs().forEach(mvp -> {
            if (StringUtils.equals((CharSequence)mvp.getNameAsString(), (CharSequence)"path")) {
                actionPath.append(this.adjust(mvp.getValue().toString()));
            }
        }));
        annotation.toSingleMemberAnnotationExpr().ifPresent(smae -> actionPath.append(this.adjust(smae.getMemberValue().toString())));
        return actionPath.toString();
    }

    String adjust(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        String adjust = StringUtils.strip((String)path, (String)"\"");
        if (adjust.startsWith("/")) {
            return adjust;
        }
        return "/" + adjust;
    }

    List<FieldDef> readFieldDefs(ClassOrInterfaceDeclaration typeDec) {
        return this.jpf.getTypeDeclaration(typeDec).getDeclaredFields().stream().map(declaredField -> {
            try {
                FieldDef fieldDef = new FieldDef();
                fieldDef.setName(declaredField.getName());
                ResolvedType type = declaredField.getType();
                fieldDef.setType(TypeParser.getTypeDef(type));
                return fieldDef;
            }
            catch (Exception e) {
                log.debug("Unsolved : '{}' in '{}', {}", new Object[]{declaredField.getName(), typeDec.getName(), e});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void init(ClassDefRepositoryParam param) {
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)new ReflectionTypeSolver());
        param.getSrcDirs().stream().forEach(srcDir -> combinedTypeSolver.add((TypeSolver)new JavaParserTypeSolver(srcDir.toFile())));
        param.getBinDirs().stream().forEach(binDir -> combinedTypeSolver.add((TypeSolver)ClassDirTypeSolver.get(binDir)));
        if (param.getJarList() != null && param.getJarList().toFile().exists()) {
            try {
                String jarListStr = new String(Files.readAllBytes(param.getJarList()));
                for (String line : jarListStr.split(File.pathSeparator + "|" + System.lineSeparator())) {
                    try {
                        combinedTypeSolver.add((TypeSolver)JarTypeSolver.getJarTypeSolver((String)line));
                        log.info("jar is added. {}", (Object)line);
                    }
                    catch (IOException e) {
                        log.warn("warn ", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.jpf = JavaParserFacade.get((TypeSolver)combinedTypeSolver);
        this.methodCallVisitor = new MethodCallVisitor(this.jpf);
    }

    public ClassDefReaderJavaParserImpl() {
    }
}

