/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.sitoolkit.cv.core.domain.classdef.filter.ClassDefFilterCondition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDefFilterConditionReader {
    private static final Logger log = LoggerFactory.getLogger(ClassDefFilterConditionReader.class);

    public static Optional<ClassDefFilterCondition> read(Path projectPath) {
        File jsonFile = projectPath.resolve("sit-cv-filter.json").toFile();
        ObjectMapper mapper = new ObjectMapper();
        try {
            ClassDefFilterCondition condition = (ClassDefFilterCondition)mapper.readValue(jsonFile, ClassDefFilterCondition.class);
            log.debug("class filter read : file = {} ", (Object)jsonFile.getAbsolutePath());
            return Optional.ofNullable(condition);
        }
        catch (IOException e) {
            log.debug("reading filter file failed : file = {} : exception = {}", (Object)jsonFile, (Object)e);
            return Optional.empty();
        }
    }
}

