/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef.filter;

import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.classdef.filter.ClassDefFilterCondition;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDefFilter
implements Predicate<ClassDef> {
    private static final Logger log = LoggerFactory.getLogger(ClassDefFilter.class);
    ClassDefFilterCondition condition;

    @Override
    public boolean test(ClassDef type) {
        return this.testType(type) || this.testAnnotation(type);
    }

    boolean testType(ClassDef type) {
        if (this.condition == null) {
            return true;
        }
        return this.condition.getTypes().stream().anyMatch(pattern -> this.testType(type, (String)pattern));
    }

    boolean testType(ClassDef type, String typePattern) {
        boolean result = this.testType(type.getPkg() + "." + type.getName(), typePattern);
        if (result) {
            log.debug("{}.{} matched to pattern '{}'", new Object[]{type.getPkg(), type.getName(), typePattern});
        }
        return result;
    }

    boolean testType(String targetType, String typePattern) {
        return targetType.matches(this.toRegex(typePattern));
    }

    String toRegex(String typePattern) {
        return typePattern.replace(".", "\\.").replace("*", "[^.]*").replace("\\.\\.", "\\.(.*\\.)?");
    }

    boolean testAnnotation(ClassDef type) {
        if (this.condition == null) {
            return true;
        }
        return this.condition.getAnnotations().stream().anyMatch(annotation -> this.testAnnotation(type, (String)annotation));
    }

    boolean testAnnotation(ClassDef type, String annotation) {
        boolean result = type.getAnnotations().contains(annotation);
        if (result) {
            log.debug("{}.{} matched to Annotation '{}'", new Object[]{type.getPkg(), type.getName(), annotation});
        }
        return result;
    }

    public void setCondition(ClassDefFilterCondition condition) {
        this.condition = condition;
    }
}

