/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef;

import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.classdef.ClassDefRepository;
import io.sitoolkit.cv.core.domain.classdef.FieldDef;
import io.sitoolkit.cv.core.domain.classdef.MethodCallDef;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.classdef.TypeDef;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDefRepositoryMemImpl
implements ClassDefRepository {
    private static final Logger log = LoggerFactory.getLogger(ClassDefRepositoryMemImpl.class);
    private Map<String, ClassDef> classDefMap = new HashMap<String, ClassDef>();
    private Map<String, MethodDef> methodDefMap = new HashMap<String, MethodDef>();
    private Map<String, List<MethodCallDef>> methodCallMap = new HashMap<String, List<MethodCallDef>>();

    @Override
    public void save(ClassDef classDef) {
        this.classDefMap.put(classDef.getPkg() + "." + classDef.getName(), classDef);
        classDef.getMethods().stream().forEach(methodDef -> {
            this.methodDefMap.put(methodDef.getQualifiedSignature(), (MethodDef)methodDef);
            this.methodCallMap.put(methodDef.getQualifiedSignature(), methodDef.getMethodCalls());
        });
    }

    @Override
    public Collection<ClassDef> getAllClassDefs() {
        return Collections.unmodifiableCollection(this.classDefMap.values());
    }

    @Override
    public int countClassDefs() {
        return this.classDefMap.size();
    }

    @Override
    public void solveReferences() {
        this.solveMethodCalls();
        this.solveClassRefs();
    }

    public void solveMethodCalls() {
        this.classDefMap.values().stream().forEach(this::solveMethodCalls);
    }

    public void solveMethodCalls(ClassDef classDef) {
        classDef.getMethods().stream().forEach(methodDef -> {
            this.solveMethodType((MethodDef)methodDef);
            methodDef.getMethodCalls().stream().forEach(methodCall -> this.solveMethodCall((MethodCallDef)methodCall));
        });
    }

    private void solveMethodCall(MethodCallDef methodCall) {
        List<MethodCallDef> calledMethods;
        this.solveMethodType(methodCall);
        this.soleveMethodCallClass(methodCall);
        if (methodCall.getMethodCalls().isEmpty() && (calledMethods = this.methodCallMap.get(methodCall.getQualifiedSignature())) != null) {
            methodCall.setMethodCalls(calledMethods);
            calledMethods.stream().forEach(calledMethod -> this.soleveMethodCallClass((MethodCallDef)calledMethod));
        }
    }

    private void solveMethodType(MethodDef methodDef) {
        methodDef.getParamTypes().forEach(this::solveClassRef);
        this.solveClassRef(methodDef.getReturnType());
    }

    private void solveClassRef(TypeDef type) {
        type.getTypeParamsRecursively().forEach(t -> {
            ClassDef refType = this.classDefMap.get(t.getName());
            if (refType != null) {
                t.setClassRef(refType);
            }
        });
    }

    private void soleveMethodCallClass(MethodCallDef calledMethod) {
        ClassDef calledMethodClass = this.classDefMap.get(calledMethod.getPackageName() + "." + calledMethod.getClassName());
        calledMethod.setClassDef(calledMethodClass);
    }

    @Override
    public Set<String> getEntryPoints() {
        return this.getAllClassDefs().stream().filter(clazz -> clazz.getName().endsWith("Controller")).map(ClassDef::getMethods).flatMap(Collection::stream).map(MethodDef::getQualifiedSignature).collect(Collectors.toSet());
    }

    @Override
    public MethodDef findMethodByQualifiedSignature(String qualifiedSignature) {
        return this.methodDefMap.get(qualifiedSignature);
    }

    @Override
    public ClassDef findClassByQualifiedName(String qualifiedName) {
        return this.classDefMap.get(qualifiedName);
    }

    public void solveClassRefs() {
        this.classDefMap.values().stream().forEach(this::solveClassRefs);
    }

    void solveClassRefs(ClassDef clazz) {
        log.debug("solving class {}", (Object)clazz.getName());
        clazz.getFields().stream().map(FieldDef::getType).forEach(this::solveClassRef);
        if (clazz.isClass()) {
            clazz.getImplInterfaces().stream().forEach(ifName -> {
                ClassDef refType = this.classDefMap.get(ifName);
                if (refType != null) {
                    refType.getKnownImplClasses().add(clazz);
                    log.debug("{} is Known implementation of {}", (Object)clazz.getName(), ifName);
                }
            });
        }
    }
}

