/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.app.designdoc;

import io.sitoolkit.cv.core.app.designdoc.ClassDefChangeEventListener;
import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.classdef.ClassDefReader;
import io.sitoolkit.cv.core.domain.classdef.ClassDefRepository;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.classdef.filter.ClassDefFilter;
import io.sitoolkit.cv.core.domain.classdef.filter.ClassDefFilterConditionReader;
import io.sitoolkit.cv.core.domain.designdoc.DesignDoc;
import io.sitoolkit.cv.core.domain.designdoc.Diagram;
import io.sitoolkit.cv.core.domain.uml.ClassDiagram;
import io.sitoolkit.cv.core.domain.uml.ClassDiagramProcessor;
import io.sitoolkit.cv.core.domain.uml.DiagramWriter;
import io.sitoolkit.cv.core.domain.uml.LifeLineDef;
import io.sitoolkit.cv.core.domain.uml.SequenceDiagram;
import io.sitoolkit.cv.core.domain.uml.SequenceDiagramProcessor;
import io.sitoolkit.cv.core.infra.watcher.InputSourceWatcher;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesignDocService {
    private static final Logger log = LoggerFactory.getLogger(DesignDocService.class);
    @Resource
    ClassDefReader classDefReader;
    @Resource
    SequenceDiagramProcessor sequenceProcessor;
    @Resource
    ClassDiagramProcessor classProcessor;
    @Resource
    DiagramWriter<SequenceDiagram> sequenceWriter;
    @Resource
    DiagramWriter<ClassDiagram> classWriter;
    @Resource
    ClassDefFilter classFilter;
    @Resource
    ClassDefRepository classDefRepository;
    @Resource
    InputSourceWatcher watcher;
    Map<String, Set<String>> entryPointMap = new HashMap<String, Set<String>>();

    public void loadDir(Path projDir, Path srcDir) {
        this.classDefReader.readDir(srcDir);
        ClassDefFilterConditionReader.read(projDir).ifPresent(this.classFilter::setCondition);
    }

    public void watchDir(Path srcDir, ClassDefChangeEventListener listener) {
        this.watcher.setContinue(true);
        try {
            Files.walk(srcDir, new FileVisitOption[0]).forEach(path -> this.watcher.watch(path.toFile().getAbsolutePath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.watcher.start(inputSources -> {
            this.classDefReader.init(srcDir);
            inputSources.stream().forEach(inputSource -> this.classDefReader.readJava(Paths.get(inputSource, new String[0])).ifPresent(clazz -> {
                this.classDefRepository.save((ClassDef)clazz);
                this.classDefRepository.solveReferences();
                log.info("Read {}", clazz);
                Set<String> entryPoints = this.entryPointMap.get(clazz.getSourceId());
                if (entryPoints != null) {
                    entryPoints.stream().forEach(listener::onChange);
                }
            }));
        });
    }

    public Set<String> getAllIds() {
        return this.classDefRepository.getEntryPoints();
    }

    public DesignDoc get(String designDocId) {
        MethodDef entryPoint = this.classDefRepository.findMethodByQualifiedSignature(designDocId);
        log.info("Build diagram for {}", (Object)entryPoint);
        LifeLineDef lifeLine = this.sequenceProcessor.process(entryPoint.getClassDef(), entryPoint);
        lifeLine.getAllSourceIds().stream().forEach(sourceId -> {
            Set entryPoints = this.entryPointMap.computeIfAbsent((String)sourceId, key -> new HashSet());
            entryPoints.add(entryPoint.getQualifiedSignature());
        });
        Diagram sequenceDiagram = this.sequenceWriter.write(SequenceDiagram.builder().entryLifeLine(lifeLine).build());
        Diagram classDiagram = this.classWriter.write(this.classProcessor.process(entryPoint));
        DesignDoc doc = new DesignDoc();
        doc.add(sequenceDiagram);
        doc.add(classDiagram);
        return doc;
    }
}

