/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.design.pres.designdoc;

import io.sitoolkit.cv.core.app.designdoc.DesignDocService;
import io.sitoolkit.cv.core.domain.designdoc.DesignDoc;
import io.sitoolkit.design.ApplicationConfig;
import io.sitoolkit.design.pres.designdoc.DetailResponse;
import io.sitoolkit.design.pres.designdoc.ListResponse;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class DesignDocPublisher {
    private static final Logger log = LoggerFactory.getLogger(DesignDocPublisher.class);
    @Autowired
    DesignDocService service;
    @Autowired
    SimpMessagingTemplate template;
    @Autowired
    ApplicationConfig config;

    @PostConstruct
    public void init() {
        log.debug("loading project:{}", (Object)this.config.getTargetProjectPath());
        Path projDir = Paths.get(this.config.getTargetProjectPath(), new String[0]);
        Path srcDir = Paths.get(this.config.getTargetProjectPath(), "src/main/java");
        this.service.loadDir(projDir, srcDir);
        ListResponse listResponse = this.buildDesingDocList();
        this.template.convertAndSend((Object)"/topic/designdoc/list", (Object)listResponse);
        this.service.watchDir(srcDir, entryPoint -> this.publishDetail(entryPoint));
    }

    @MessageMapping(value={"/designdoc/list"})
    @SendTo(value={"/topic/designdoc/list"})
    public ListResponse buildDesingDocList() {
        ListResponse listResponse = new ListResponse();
        listResponse.getDesignDocIds().addAll(this.service.getAllIds());
        return listResponse;
    }

    @MessageMapping(value={"/designdoc/detail"})
    public void publishDetail(String designDocId) {
        DetailResponse response = new DetailResponse();
        DesignDoc designDoc = this.service.get(designDocId);
        designDoc.getAllDiagrams().stream().forEach(diagram -> {
            String data = "data:image/png;base64," + Base64.getEncoder().encodeToString(diagram.getData());
            response.getDiagrams().put(diagram.getId(), data);
        });
        this.template.convertAndSend((Object)("/topic/designdoc/detail/" + designDocId), (Object)response);
    }

    @RequestMapping(value={""})
    public String index() {
        return "index.html";
    }
}

