/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.design;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(ignoreResourceNotFound=true, value={"classpath:application.properties"})
public class ApplicationConfig {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfig.class);
    @Autowired
    ApplicationArguments appArgs;
    @Value(value="${targetProject.path}")
    private String targetProjectPath;

    @PostConstruct
    public void init() {
        this.processAppArg(0, arg_0 -> this.setTargetProjectPath(arg_0));
    }

    private void processAppArg(int argIndex, Consumer<String> argSetter) {
        List args = this.appArgs.getNonOptionArgs();
        if (args.size() > argIndex) {
            String arg = (String)args.get(argIndex);
            argSetter.accept(arg);
            log.debug("appArg({}):{} set", (Object)argIndex, (Object)arg);
        } else {
            log.debug("aapArg({}) is not exist", (Object)argIndex);
        }
    }

    public String getTargetProjectPath() {
        return this.targetProjectPath;
    }

    private void setTargetProjectPath(String targetProjectPath) {
        this.targetProjectPath = targetProjectPath;
    }
}

