package com.shipsy.ondemand.riderapp.shared.cache.shared

import com.shipsy.ondemand.riderapp.framework.`data`.orderhistory.DominoEventModel
import com.shipsy.ondemand.riderapp.framework.network.model.login.HUDetail
import com.shipsy.ondemand.riderapp.framework.network.model.login.Location
import com.shipsy.ondemand.riderapp.framework.network.model.login.OnDemandDiscount
import com.shipsy.ondemand.riderapp.framework.network.model.login.PaymentDetails
import com.shipsy.ondemand.riderapp.framework.network.model.login.PieceDetails
import com.shipsy.ondemand.riderapp.framework.network.model.login.RelationData
import com.shipsy.ondemand.riderapp.framework.network.model.login.UndeliveredReason
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.Discount
import com.shipsy.ondemand.riderapp.shared.cache.AppDatabase
import com.shipsy.ondemand.riderapp.shared.cache.AppDatabaseQueries
import com.shipsy.ondemand.riderapp.shared.cache.CurrentOrders
import com.shipsy.ondemand.riderapp.shared.cache.OrderHistory
import com.shipsy.ondemand.riderapp.shared.cache.RiderStateEvents
import com.squareup.sqldelight.Query
import com.squareup.sqldelight.TransacterImpl
import com.squareup.sqldelight.`internal`.copyOnWriteList
import com.squareup.sqldelight.db.SqlCursor
import com.squareup.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.reflect.KClass

internal val KClass<AppDatabase>.schema: SqlDriver.Schema
  get() = AppDatabaseImpl.Schema

internal fun KClass<AppDatabase>.newInstance(
  driver: SqlDriver,
  CurrentOrdersAdapter: CurrentOrders.Adapter,
  OrderHistoryAdapter: OrderHistory.Adapter,
  RiderStateEventsAdapter: RiderStateEvents.Adapter
): AppDatabase = AppDatabaseImpl(driver, CurrentOrdersAdapter, OrderHistoryAdapter,
    RiderStateEventsAdapter)

private class AppDatabaseImpl(
  driver: SqlDriver,
  internal val CurrentOrdersAdapter: CurrentOrders.Adapter,
  internal val OrderHistoryAdapter: OrderHistory.Adapter,
  internal val RiderStateEventsAdapter: RiderStateEvents.Adapter
) : TransacterImpl(driver), AppDatabase {
  public override val appDatabaseQueries: AppDatabaseQueriesImpl = AppDatabaseQueriesImpl(this,
      driver)

  public object Schema : SqlDriver.Schema {
    public override val version: Int
      get() = 1

    public override fun create(driver: SqlDriver): Unit {
      driver.execute(null, """
          |CREATE TABLE CurrentOrders(
          |    id INTEGER PRIMARY KEY AUTOINCREMENT ,
          |    reference_number TEXT NOT NULL,
          |    status TEXT NOT NULL,
          |    task_type TEXT,
          |    is_cod INTEGER DEFAULT FALSE ,
          |    cod_amount REAL,
          |    is_vip INTEGER DEFAULT FALSE,
          |    is_bulk INTEGER DEFAULT FALSE,
          |    notes TEXT,
          |    payment_details TEXT,
          |    pieces_details TEXT,
          |    order_number TEXT NOT NULL,
          |    order_type TEXT,
          |    otp TEXT,
          |    makeline_time INTEGER,
          |    final_amount REAL,
          |    order_promise_start_time_ondemand INTEGER ,
          |    ondemand_delivery_promise_mins INTEGER,
          |    priority INTEGER,
          |    ondemand_discount TEXT,
          |    lastUpdatedAt INTEGER,
          |    assignTime INTEGER,
          |    storageLocation TEXT,
          |    huDetails TEXT,
          |    location TEXT,
          |    tip REAL,
          |    eligible_payout REAL,
          |    order_instructions TEXT
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE RiderStateEvents(
          |    id INTEGER PRIMARY KEY AUTOINCREMENT,
          |    type TEXT NOT NULL,
          |    reference_numbers TEXT NOT NULL ,
          |    transaction_id TEXT NOT NULL,
          |    vehicle_number TEXT,
          |    skip_vehicle_scan_reason TEXT,
          |    timestamp INTEGER NOT NULL,
          |    lat REAL,
          |    lng REAL,
          |    payment_details TEXT,
          |    auto_swipe INTEGER,
          |    discount TEXT,
          |    reason TEXT,
          |    receiver_relation TEXT,
          |    hu_details TEXT,
          |    pieces_status_detail TEXT,
          |    partialDeliveryReason TEXT,
          |    retryCount INTEGER
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE OrderHistory(
          |    id INTEGER PRIMARY KEY AUTOINCREMENT,
          |    reference_number TEXT NOT NULL,
          |    date TEXT NOT NULL,
          |    order_time INTEGER NOT NULL,
          |    order_number TEXT NOT NULL,
          |    is_vip INTEGER,
          |    rider_score TEXT NOT NULL,
          |    customer_name TEXT NOT NULL,
          |    customer_address TEXT NOT NULL,
          |    discount_type TEXT NOT NULL,
          |    discount_amount REAL NOT NULL,
          |    payment_mode TEXT NOT NULL,
          |    bill_amount REAL NOT NULL,
          |    cod_amount REAL NOT NULL ,
          |    is_canceled INTEGER,
          |    event_details TEXT NOT NULL,
          |    hub_name TEXT NOT NULL,
          |    hub_code TEXT NOT NULL,
          |    childOrderNumber TEXT ,
          |    orderTags TEXT,
          |    tip REAL,
          |    eligiblePayout REAL
          |)
          """.trimMargin(), 0)
    }

    public override fun migrate(
      driver: SqlDriver,
      oldVersion: Int,
      newVersion: Int
    ): Unit {
    }
  }
}

private class AppDatabaseQueriesImpl(
  private val database: AppDatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), AppDatabaseQueries {
  internal val getOrdersByReferenceNumber: MutableList<Query<*>> = copyOnWriteList()

  internal val getOrdersByReferenceNumbers: MutableList<Query<*>> = copyOnWriteList()

  internal val getReferenceNumbersByOrderNumber: MutableList<Query<*>> = copyOnWriteList()

  internal val getReferenceNumbersByOrderNumbers: MutableList<Query<*>> = copyOnWriteList()

  internal val getOrderByReferenceNumberWithTaskType: MutableList<Query<*>> = copyOnWriteList()

  internal val getAllCurrentOrders: MutableList<Query<*>> = copyOnWriteList()

  internal val getCurrentOrdersByStatus: MutableList<Query<*>> = copyOnWriteList()

  internal val getCurrentOrderByStatusAndTaskType: MutableList<Query<*>> = copyOnWriteList()

  internal val getCurrentOrdersByStatusPriority: MutableList<Query<*>> = copyOnWriteList()

  internal val currentOrdersByNotStatus: MutableList<Query<*>> = copyOnWriteList()

  internal val getRiderStateEventDataItems: MutableList<Query<*>> = copyOnWriteList()

  internal val shouldUpdateLocalState: MutableList<Query<*>> = copyOnWriteList()

  internal val getOrdersByDate: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> getOrdersByReferenceNumber(reference_number: String, mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T> = GetOrdersByReferenceNumberQuery(reference_number) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3),
      cursor.getLong(4)?.let { it == 1L },
      cursor.getDouble(5),
      cursor.getLong(6)?.let { it == 1L },
      cursor.getLong(7)?.let { it == 1L },
      cursor.getString(8),
      cursor.getString(9)?.let { database.CurrentOrdersAdapter.payment_detailsAdapter.decode(it) },
      cursor.getString(10)?.let { database.CurrentOrdersAdapter.pieces_detailsAdapter.decode(it) },
      cursor.getString(11)!!,
      cursor.getString(12),
      cursor.getString(13),
      cursor.getLong(14),
      cursor.getDouble(15),
      cursor.getLong(16),
      cursor.getLong(17),
      cursor.getLong(18),
      cursor.getString(19)?.let { database.CurrentOrdersAdapter.ondemand_discountAdapter.decode(it)
          },
      cursor.getLong(20),
      cursor.getLong(21),
      cursor.getString(22),
      cursor.getString(23)?.let { database.CurrentOrdersAdapter.huDetailsAdapter.decode(it) },
      cursor.getString(24)?.let { database.CurrentOrdersAdapter.locationAdapter.decode(it) },
      cursor.getDouble(25),
      cursor.getDouble(26),
      cursor.getString(27)?.let { database.CurrentOrdersAdapter.order_instructionsAdapter.decode(it)
          }
    )
  }

  public override fun getOrdersByReferenceNumber(reference_number: String): Query<CurrentOrders> =
      getOrdersByReferenceNumber(reference_number) { id, reference_number_, status, task_type,
      is_cod, cod_amount, is_vip, is_bulk, notes, payment_details, pieces_details, order_number,
      order_type, otp, makeline_time, final_amount, order_promise_start_time_ondemand,
      ondemand_delivery_promise_mins, priority, ondemand_discount, lastUpdatedAt, assignTime,
      storageLocation, huDetails, location, tip, eligible_payout, order_instructions ->
    CurrentOrders(
      id,
      reference_number_,
      status,
      task_type,
      is_cod,
      cod_amount,
      is_vip,
      is_bulk,
      notes,
      payment_details,
      pieces_details,
      order_number,
      order_type,
      otp,
      makeline_time,
      final_amount,
      order_promise_start_time_ondemand,
      ondemand_delivery_promise_mins,
      priority,
      ondemand_discount,
      lastUpdatedAt,
      assignTime,
      storageLocation,
      huDetails,
      location,
      tip,
      eligible_payout,
      order_instructions
    )
  }

  public override fun <T : Any> getOrdersByReferenceNumbers(reference_number: Collection<String>,
      mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T> = GetOrdersByReferenceNumbersQuery(reference_number) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3),
      cursor.getLong(4)?.let { it == 1L },
      cursor.getDouble(5),
      cursor.getLong(6)?.let { it == 1L },
      cursor.getLong(7)?.let { it == 1L },
      cursor.getString(8),
      cursor.getString(9)?.let { database.CurrentOrdersAdapter.payment_detailsAdapter.decode(it) },
      cursor.getString(10)?.let { database.CurrentOrdersAdapter.pieces_detailsAdapter.decode(it) },
      cursor.getString(11)!!,
      cursor.getString(12),
      cursor.getString(13),
      cursor.getLong(14),
      cursor.getDouble(15),
      cursor.getLong(16),
      cursor.getLong(17),
      cursor.getLong(18),
      cursor.getString(19)?.let { database.CurrentOrdersAdapter.ondemand_discountAdapter.decode(it)
          },
      cursor.getLong(20),
      cursor.getLong(21),
      cursor.getString(22),
      cursor.getString(23)?.let { database.CurrentOrdersAdapter.huDetailsAdapter.decode(it) },
      cursor.getString(24)?.let { database.CurrentOrdersAdapter.locationAdapter.decode(it) },
      cursor.getDouble(25),
      cursor.getDouble(26),
      cursor.getString(27)?.let { database.CurrentOrdersAdapter.order_instructionsAdapter.decode(it)
          }
    )
  }

  public override fun getOrdersByReferenceNumbers(reference_number: Collection<String>):
      Query<CurrentOrders> = getOrdersByReferenceNumbers(reference_number) { id, reference_number_,
      status, task_type, is_cod, cod_amount, is_vip, is_bulk, notes, payment_details,
      pieces_details, order_number, order_type, otp, makeline_time, final_amount,
      order_promise_start_time_ondemand, ondemand_delivery_promise_mins, priority,
      ondemand_discount, lastUpdatedAt, assignTime, storageLocation, huDetails, location, tip,
      eligible_payout, order_instructions ->
    CurrentOrders(
      id,
      reference_number_,
      status,
      task_type,
      is_cod,
      cod_amount,
      is_vip,
      is_bulk,
      notes,
      payment_details,
      pieces_details,
      order_number,
      order_type,
      otp,
      makeline_time,
      final_amount,
      order_promise_start_time_ondemand,
      ondemand_delivery_promise_mins,
      priority,
      ondemand_discount,
      lastUpdatedAt,
      assignTime,
      storageLocation,
      huDetails,
      location,
      tip,
      eligible_payout,
      order_instructions
    )
  }

  public override fun getReferenceNumbersByOrderNumber(order_number: String): Query<String> =
      GetReferenceNumbersByOrderNumberQuery(order_number) { cursor ->
    cursor.getString(0)!!
  }

  public override fun getReferenceNumbersByOrderNumbers(order_number: Collection<String>):
      Query<String> = GetReferenceNumbersByOrderNumbersQuery(order_number) { cursor ->
    cursor.getString(0)!!
  }

  public override fun <T : Any> getOrderByReferenceNumberWithTaskType(
    reference_number: String,
    task_type: String?,
    mapper: (
      id: Long,
      reference_number: String,
      status: String,
      task_type: String?,
      is_cod: Boolean?,
      cod_amount: Double?,
      is_vip: Boolean?,
      is_bulk: Boolean?,
      notes: String?,
      payment_details: List<PaymentDetails>?,
      pieces_details: List<PieceDetails>?,
      order_number: String,
      order_type: String?,
      otp: String?,
      makeline_time: Long?,
      final_amount: Double?,
      order_promise_start_time_ondemand: Long?,
      ondemand_delivery_promise_mins: Long?,
      priority: Long?,
      ondemand_discount: OnDemandDiscount?,
      lastUpdatedAt: Long?,
      assignTime: Long?,
      storageLocation: String?,
      huDetails: List<HUDetail>?,
      location: Location?,
      tip: Double?,
      eligible_payout: Double?,
      order_instructions: List<String>?
    ) -> T
  ): Query<T> = GetOrderByReferenceNumberWithTaskTypeQuery(reference_number, task_type) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3),
      cursor.getLong(4)?.let { it == 1L },
      cursor.getDouble(5),
      cursor.getLong(6)?.let { it == 1L },
      cursor.getLong(7)?.let { it == 1L },
      cursor.getString(8),
      cursor.getString(9)?.let { database.CurrentOrdersAdapter.payment_detailsAdapter.decode(it) },
      cursor.getString(10)?.let { database.CurrentOrdersAdapter.pieces_detailsAdapter.decode(it) },
      cursor.getString(11)!!,
      cursor.getString(12),
      cursor.getString(13),
      cursor.getLong(14),
      cursor.getDouble(15),
      cursor.getLong(16),
      cursor.getLong(17),
      cursor.getLong(18),
      cursor.getString(19)?.let { database.CurrentOrdersAdapter.ondemand_discountAdapter.decode(it)
          },
      cursor.getLong(20),
      cursor.getLong(21),
      cursor.getString(22),
      cursor.getString(23)?.let { database.CurrentOrdersAdapter.huDetailsAdapter.decode(it) },
      cursor.getString(24)?.let { database.CurrentOrdersAdapter.locationAdapter.decode(it) },
      cursor.getDouble(25),
      cursor.getDouble(26),
      cursor.getString(27)?.let { database.CurrentOrdersAdapter.order_instructionsAdapter.decode(it)
          }
    )
  }

  public override fun getOrderByReferenceNumberWithTaskType(reference_number: String,
      task_type: String?): Query<CurrentOrders> =
      getOrderByReferenceNumberWithTaskType(reference_number, task_type) { id, reference_number_,
      status, task_type_, is_cod, cod_amount, is_vip, is_bulk, notes, payment_details,
      pieces_details, order_number, order_type, otp, makeline_time, final_amount,
      order_promise_start_time_ondemand, ondemand_delivery_promise_mins, priority,
      ondemand_discount, lastUpdatedAt, assignTime, storageLocation, huDetails, location, tip,
      eligible_payout, order_instructions ->
    CurrentOrders(
      id,
      reference_number_,
      status,
      task_type_,
      is_cod,
      cod_amount,
      is_vip,
      is_bulk,
      notes,
      payment_details,
      pieces_details,
      order_number,
      order_type,
      otp,
      makeline_time,
      final_amount,
      order_promise_start_time_ondemand,
      ondemand_delivery_promise_mins,
      priority,
      ondemand_discount,
      lastUpdatedAt,
      assignTime,
      storageLocation,
      huDetails,
      location,
      tip,
      eligible_payout,
      order_instructions
    )
  }

  public override fun <T : Any> getAllCurrentOrders(mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T> = Query(2124972648, getAllCurrentOrders, driver, "AppDatabase.sq",
      "getAllCurrentOrders", "SELECT * FROM CurrentOrders") { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3),
      cursor.getLong(4)?.let { it == 1L },
      cursor.getDouble(5),
      cursor.getLong(6)?.let { it == 1L },
      cursor.getLong(7)?.let { it == 1L },
      cursor.getString(8),
      cursor.getString(9)?.let { database.CurrentOrdersAdapter.payment_detailsAdapter.decode(it) },
      cursor.getString(10)?.let { database.CurrentOrdersAdapter.pieces_detailsAdapter.decode(it) },
      cursor.getString(11)!!,
      cursor.getString(12),
      cursor.getString(13),
      cursor.getLong(14),
      cursor.getDouble(15),
      cursor.getLong(16),
      cursor.getLong(17),
      cursor.getLong(18),
      cursor.getString(19)?.let { database.CurrentOrdersAdapter.ondemand_discountAdapter.decode(it)
          },
      cursor.getLong(20),
      cursor.getLong(21),
      cursor.getString(22),
      cursor.getString(23)?.let { database.CurrentOrdersAdapter.huDetailsAdapter.decode(it) },
      cursor.getString(24)?.let { database.CurrentOrdersAdapter.locationAdapter.decode(it) },
      cursor.getDouble(25),
      cursor.getDouble(26),
      cursor.getString(27)?.let { database.CurrentOrdersAdapter.order_instructionsAdapter.decode(it)
          }
    )
  }

  public override fun getAllCurrentOrders(): Query<CurrentOrders> = getAllCurrentOrders { id,
      reference_number, status, task_type, is_cod, cod_amount, is_vip, is_bulk, notes,
      payment_details, pieces_details, order_number, order_type, otp, makeline_time, final_amount,
      order_promise_start_time_ondemand, ondemand_delivery_promise_mins, priority,
      ondemand_discount, lastUpdatedAt, assignTime, storageLocation, huDetails, location, tip,
      eligible_payout, order_instructions ->
    CurrentOrders(
      id,
      reference_number,
      status,
      task_type,
      is_cod,
      cod_amount,
      is_vip,
      is_bulk,
      notes,
      payment_details,
      pieces_details,
      order_number,
      order_type,
      otp,
      makeline_time,
      final_amount,
      order_promise_start_time_ondemand,
      ondemand_delivery_promise_mins,
      priority,
      ondemand_discount,
      lastUpdatedAt,
      assignTime,
      storageLocation,
      huDetails,
      location,
      tip,
      eligible_payout,
      order_instructions
    )
  }

  public override fun <T : Any> getCurrentOrdersByStatus(status: Collection<String>, mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T> = GetCurrentOrdersByStatusQuery(status) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3),
      cursor.getLong(4)?.let { it == 1L },
      cursor.getDouble(5),
      cursor.getLong(6)?.let { it == 1L },
      cursor.getLong(7)?.let { it == 1L },
      cursor.getString(8),
      cursor.getString(9)?.let { database.CurrentOrdersAdapter.payment_detailsAdapter.decode(it) },
      cursor.getString(10)?.let { database.CurrentOrdersAdapter.pieces_detailsAdapter.decode(it) },
      cursor.getString(11)!!,
      cursor.getString(12),
      cursor.getString(13),
      cursor.getLong(14),
      cursor.getDouble(15),
      cursor.getLong(16),
      cursor.getLong(17),
      cursor.getLong(18),
      cursor.getString(19)?.let { database.CurrentOrdersAdapter.ondemand_discountAdapter.decode(it)
          },
      cursor.getLong(20),
      cursor.getLong(21),
      cursor.getString(22),
      cursor.getString(23)?.let { database.CurrentOrdersAdapter.huDetailsAdapter.decode(it) },
      cursor.getString(24)?.let { database.CurrentOrdersAdapter.locationAdapter.decode(it) },
      cursor.getDouble(25),
      cursor.getDouble(26),
      cursor.getString(27)?.let { database.CurrentOrdersAdapter.order_instructionsAdapter.decode(it)
          }
    )
  }

  public override fun getCurrentOrdersByStatus(status: Collection<String>): Query<CurrentOrders> =
      getCurrentOrdersByStatus(status) { id, reference_number, status_, task_type, is_cod,
      cod_amount, is_vip, is_bulk, notes, payment_details, pieces_details, order_number, order_type,
      otp, makeline_time, final_amount, order_promise_start_time_ondemand,
      ondemand_delivery_promise_mins, priority, ondemand_discount, lastUpdatedAt, assignTime,
      storageLocation, huDetails, location, tip, eligible_payout, order_instructions ->
    CurrentOrders(
      id,
      reference_number,
      status_,
      task_type,
      is_cod,
      cod_amount,
      is_vip,
      is_bulk,
      notes,
      payment_details,
      pieces_details,
      order_number,
      order_type,
      otp,
      makeline_time,
      final_amount,
      order_promise_start_time_ondemand,
      ondemand_delivery_promise_mins,
      priority,
      ondemand_discount,
      lastUpdatedAt,
      assignTime,
      storageLocation,
      huDetails,
      location,
      tip,
      eligible_payout,
      order_instructions
    )
  }

  public override fun <T : Any> getCurrentOrderByStatusAndTaskType(
    status: Collection<String>,
    task_type: String?,
    mapper: (
      id: Long,
      reference_number: String,
      status: String,
      task_type: String?,
      is_cod: Boolean?,
      cod_amount: Double?,
      is_vip: Boolean?,
      is_bulk: Boolean?,
      notes: String?,
      payment_details: List<PaymentDetails>?,
      pieces_details: List<PieceDetails>?,
      order_number: String,
      order_type: String?,
      otp: String?,
      makeline_time: Long?,
      final_amount: Double?,
      order_promise_start_time_ondemand: Long?,
      ondemand_delivery_promise_mins: Long?,
      priority: Long?,
      ondemand_discount: OnDemandDiscount?,
      lastUpdatedAt: Long?,
      assignTime: Long?,
      storageLocation: String?,
      huDetails: List<HUDetail>?,
      location: Location?,
      tip: Double?,
      eligible_payout: Double?,
      order_instructions: List<String>?
    ) -> T
  ): Query<T> = GetCurrentOrderByStatusAndTaskTypeQuery(status, task_type) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3),
      cursor.getLong(4)?.let { it == 1L },
      cursor.getDouble(5),
      cursor.getLong(6)?.let { it == 1L },
      cursor.getLong(7)?.let { it == 1L },
      cursor.getString(8),
      cursor.getString(9)?.let { database.CurrentOrdersAdapter.payment_detailsAdapter.decode(it) },
      cursor.getString(10)?.let { database.CurrentOrdersAdapter.pieces_detailsAdapter.decode(it) },
      cursor.getString(11)!!,
      cursor.getString(12),
      cursor.getString(13),
      cursor.getLong(14),
      cursor.getDouble(15),
      cursor.getLong(16),
      cursor.getLong(17),
      cursor.getLong(18),
      cursor.getString(19)?.let { database.CurrentOrdersAdapter.ondemand_discountAdapter.decode(it)
          },
      cursor.getLong(20),
      cursor.getLong(21),
      cursor.getString(22),
      cursor.getString(23)?.let { database.CurrentOrdersAdapter.huDetailsAdapter.decode(it) },
      cursor.getString(24)?.let { database.CurrentOrdersAdapter.locationAdapter.decode(it) },
      cursor.getDouble(25),
      cursor.getDouble(26),
      cursor.getString(27)?.let { database.CurrentOrdersAdapter.order_instructionsAdapter.decode(it)
          }
    )
  }

  public override fun getCurrentOrderByStatusAndTaskType(status: Collection<String>,
      task_type: String?): Query<CurrentOrders> = getCurrentOrderByStatusAndTaskType(status,
      task_type) { id, reference_number, status_, task_type_, is_cod, cod_amount, is_vip, is_bulk,
      notes, payment_details, pieces_details, order_number, order_type, otp, makeline_time,
      final_amount, order_promise_start_time_ondemand, ondemand_delivery_promise_mins, priority,
      ondemand_discount, lastUpdatedAt, assignTime, storageLocation, huDetails, location, tip,
      eligible_payout, order_instructions ->
    CurrentOrders(
      id,
      reference_number,
      status_,
      task_type_,
      is_cod,
      cod_amount,
      is_vip,
      is_bulk,
      notes,
      payment_details,
      pieces_details,
      order_number,
      order_type,
      otp,
      makeline_time,
      final_amount,
      order_promise_start_time_ondemand,
      ondemand_delivery_promise_mins,
      priority,
      ondemand_discount,
      lastUpdatedAt,
      assignTime,
      storageLocation,
      huDetails,
      location,
      tip,
      eligible_payout,
      order_instructions
    )
  }

  public override fun <T : Any> getCurrentOrdersByStatusPriority(status: Collection<String>,
      mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T> = GetCurrentOrdersByStatusPriorityQuery(status) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3),
      cursor.getLong(4)?.let { it == 1L },
      cursor.getDouble(5),
      cursor.getLong(6)?.let { it == 1L },
      cursor.getLong(7)?.let { it == 1L },
      cursor.getString(8),
      cursor.getString(9)?.let { database.CurrentOrdersAdapter.payment_detailsAdapter.decode(it) },
      cursor.getString(10)?.let { database.CurrentOrdersAdapter.pieces_detailsAdapter.decode(it) },
      cursor.getString(11)!!,
      cursor.getString(12),
      cursor.getString(13),
      cursor.getLong(14),
      cursor.getDouble(15),
      cursor.getLong(16),
      cursor.getLong(17),
      cursor.getLong(18),
      cursor.getString(19)?.let { database.CurrentOrdersAdapter.ondemand_discountAdapter.decode(it)
          },
      cursor.getLong(20),
      cursor.getLong(21),
      cursor.getString(22),
      cursor.getString(23)?.let { database.CurrentOrdersAdapter.huDetailsAdapter.decode(it) },
      cursor.getString(24)?.let { database.CurrentOrdersAdapter.locationAdapter.decode(it) },
      cursor.getDouble(25),
      cursor.getDouble(26),
      cursor.getString(27)?.let { database.CurrentOrdersAdapter.order_instructionsAdapter.decode(it)
          }
    )
  }

  public override fun getCurrentOrdersByStatusPriority(status: Collection<String>):
      Query<CurrentOrders> = getCurrentOrdersByStatusPriority(status) { id, reference_number,
      status_, task_type, is_cod, cod_amount, is_vip, is_bulk, notes, payment_details,
      pieces_details, order_number, order_type, otp, makeline_time, final_amount,
      order_promise_start_time_ondemand, ondemand_delivery_promise_mins, priority,
      ondemand_discount, lastUpdatedAt, assignTime, storageLocation, huDetails, location, tip,
      eligible_payout, order_instructions ->
    CurrentOrders(
      id,
      reference_number,
      status_,
      task_type,
      is_cod,
      cod_amount,
      is_vip,
      is_bulk,
      notes,
      payment_details,
      pieces_details,
      order_number,
      order_type,
      otp,
      makeline_time,
      final_amount,
      order_promise_start_time_ondemand,
      ondemand_delivery_promise_mins,
      priority,
      ondemand_discount,
      lastUpdatedAt,
      assignTime,
      storageLocation,
      huDetails,
      location,
      tip,
      eligible_payout,
      order_instructions
    )
  }

  public override fun <T : Any> currentOrdersByNotStatus(status: Collection<String>, mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T> = CurrentOrdersByNotStatusQuery(status) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3),
      cursor.getLong(4)?.let { it == 1L },
      cursor.getDouble(5),
      cursor.getLong(6)?.let { it == 1L },
      cursor.getLong(7)?.let { it == 1L },
      cursor.getString(8),
      cursor.getString(9)?.let { database.CurrentOrdersAdapter.payment_detailsAdapter.decode(it) },
      cursor.getString(10)?.let { database.CurrentOrdersAdapter.pieces_detailsAdapter.decode(it) },
      cursor.getString(11)!!,
      cursor.getString(12),
      cursor.getString(13),
      cursor.getLong(14),
      cursor.getDouble(15),
      cursor.getLong(16),
      cursor.getLong(17),
      cursor.getLong(18),
      cursor.getString(19)?.let { database.CurrentOrdersAdapter.ondemand_discountAdapter.decode(it)
          },
      cursor.getLong(20),
      cursor.getLong(21),
      cursor.getString(22),
      cursor.getString(23)?.let { database.CurrentOrdersAdapter.huDetailsAdapter.decode(it) },
      cursor.getString(24)?.let { database.CurrentOrdersAdapter.locationAdapter.decode(it) },
      cursor.getDouble(25),
      cursor.getDouble(26),
      cursor.getString(27)?.let { database.CurrentOrdersAdapter.order_instructionsAdapter.decode(it)
          }
    )
  }

  public override fun currentOrdersByNotStatus(status: Collection<String>): Query<CurrentOrders> =
      currentOrdersByNotStatus(status) { id, reference_number, status_, task_type, is_cod,
      cod_amount, is_vip, is_bulk, notes, payment_details, pieces_details, order_number, order_type,
      otp, makeline_time, final_amount, order_promise_start_time_ondemand,
      ondemand_delivery_promise_mins, priority, ondemand_discount, lastUpdatedAt, assignTime,
      storageLocation, huDetails, location, tip, eligible_payout, order_instructions ->
    CurrentOrders(
      id,
      reference_number,
      status_,
      task_type,
      is_cod,
      cod_amount,
      is_vip,
      is_bulk,
      notes,
      payment_details,
      pieces_details,
      order_number,
      order_type,
      otp,
      makeline_time,
      final_amount,
      order_promise_start_time_ondemand,
      ondemand_delivery_promise_mins,
      priority,
      ondemand_discount,
      lastUpdatedAt,
      assignTime,
      storageLocation,
      huDetails,
      location,
      tip,
      eligible_payout,
      order_instructions
    )
  }

  public override fun <T : Any> getRiderStateEventDataItems(mapper: (
    id: Long,
    type: String,
    reference_numbers: List<String>,
    transaction_id: String,
    vehicle_number: String?,
    skip_vehicle_scan_reason: String?,
    timestamp: Long,
    lat: Double?,
    lng: Double?,
    payment_details: List<PaymentDetails>?,
    auto_swipe: Boolean?,
    discount: Discount?,
    reason: UndeliveredReason?,
    receiver_relation: RelationData?,
    hu_details: List<HUDetail>?,
    pieces_status_detail: List<PieceDetails>?,
    partialDeliveryReason: UndeliveredReason?,
    retryCount: Long?
  ) -> T): Query<T> = Query(797412510, getRiderStateEventDataItems, driver, "AppDatabase.sq",
      "getRiderStateEventDataItems", "SELECT * FROM RiderStateEvents") { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      database.RiderStateEventsAdapter.reference_numbersAdapter.decode(cursor.getString(2)!!),
      cursor.getString(3)!!,
      cursor.getString(4),
      cursor.getString(5),
      cursor.getLong(6)!!,
      cursor.getDouble(7),
      cursor.getDouble(8),
      cursor.getString(9)?.let { database.RiderStateEventsAdapter.payment_detailsAdapter.decode(it)
          },
      cursor.getLong(10)?.let { it == 1L },
      cursor.getString(11)?.let { database.RiderStateEventsAdapter.discountAdapter.decode(it) },
      cursor.getString(12)?.let { database.RiderStateEventsAdapter.reasonAdapter.decode(it) },
      cursor.getString(13)?.let {
          database.RiderStateEventsAdapter.receiver_relationAdapter.decode(it) },
      cursor.getString(14)?.let { database.RiderStateEventsAdapter.hu_detailsAdapter.decode(it) },
      cursor.getString(15)?.let {
          database.RiderStateEventsAdapter.pieces_status_detailAdapter.decode(it) },
      cursor.getString(16)?.let {
          database.RiderStateEventsAdapter.partialDeliveryReasonAdapter.decode(it) },
      cursor.getLong(17)
    )
  }

  public override fun getRiderStateEventDataItems(): Query<RiderStateEvents> =
      getRiderStateEventDataItems { id, type, reference_numbers, transaction_id, vehicle_number,
      skip_vehicle_scan_reason, timestamp, lat, lng, payment_details, auto_swipe, discount, reason,
      receiver_relation, hu_details, pieces_status_detail, partialDeliveryReason, retryCount ->
    RiderStateEvents(
      id,
      type,
      reference_numbers,
      transaction_id,
      vehicle_number,
      skip_vehicle_scan_reason,
      timestamp,
      lat,
      lng,
      payment_details,
      auto_swipe,
      discount,
      reason,
      receiver_relation,
      hu_details,
      pieces_status_detail,
      partialDeliveryReason,
      retryCount
    )
  }

  public override fun <T : Any> shouldUpdateLocalState(mapper: (
    id: Long,
    type: String,
    reference_numbers: List<String>,
    transaction_id: String,
    vehicle_number: String?,
    skip_vehicle_scan_reason: String?,
    timestamp: Long,
    lat: Double?,
    lng: Double?,
    payment_details: List<PaymentDetails>?,
    auto_swipe: Boolean?,
    discount: Discount?,
    reason: UndeliveredReason?,
    receiver_relation: RelationData?,
    hu_details: List<HUDetail>?,
    pieces_status_detail: List<PieceDetails>?,
    partialDeliveryReason: UndeliveredReason?,
    retryCount: Long?
  ) -> T): Query<T> = Query(1589918701, shouldUpdateLocalState, driver, "AppDatabase.sq",
      "shouldUpdateLocalState", "SELECT * FROM RiderStateEvents WHERE  retryCount < 3") { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      database.RiderStateEventsAdapter.reference_numbersAdapter.decode(cursor.getString(2)!!),
      cursor.getString(3)!!,
      cursor.getString(4),
      cursor.getString(5),
      cursor.getLong(6)!!,
      cursor.getDouble(7),
      cursor.getDouble(8),
      cursor.getString(9)?.let { database.RiderStateEventsAdapter.payment_detailsAdapter.decode(it)
          },
      cursor.getLong(10)?.let { it == 1L },
      cursor.getString(11)?.let { database.RiderStateEventsAdapter.discountAdapter.decode(it) },
      cursor.getString(12)?.let { database.RiderStateEventsAdapter.reasonAdapter.decode(it) },
      cursor.getString(13)?.let {
          database.RiderStateEventsAdapter.receiver_relationAdapter.decode(it) },
      cursor.getString(14)?.let { database.RiderStateEventsAdapter.hu_detailsAdapter.decode(it) },
      cursor.getString(15)?.let {
          database.RiderStateEventsAdapter.pieces_status_detailAdapter.decode(it) },
      cursor.getString(16)?.let {
          database.RiderStateEventsAdapter.partialDeliveryReasonAdapter.decode(it) },
      cursor.getLong(17)
    )
  }

  public override fun shouldUpdateLocalState(): Query<RiderStateEvents> = shouldUpdateLocalState {
      id, type, reference_numbers, transaction_id, vehicle_number, skip_vehicle_scan_reason,
      timestamp, lat, lng, payment_details, auto_swipe, discount, reason, receiver_relation,
      hu_details, pieces_status_detail, partialDeliveryReason, retryCount ->
    RiderStateEvents(
      id,
      type,
      reference_numbers,
      transaction_id,
      vehicle_number,
      skip_vehicle_scan_reason,
      timestamp,
      lat,
      lng,
      payment_details,
      auto_swipe,
      discount,
      reason,
      receiver_relation,
      hu_details,
      pieces_status_detail,
      partialDeliveryReason,
      retryCount
    )
  }

  public override fun <T : Any> getOrdersByDate(date: String, mapper: (
    id: Long,
    reference_number: String,
    date: String,
    order_time: Long,
    order_number: String,
    is_vip: Boolean?,
    rider_score: String,
    customer_name: String,
    customer_address: String,
    discount_type: String,
    discount_amount: Double,
    payment_mode: String,
    bill_amount: Double,
    cod_amount: Double,
    is_canceled: Boolean?,
    event_details: List<DominoEventModel>,
    hub_name: String,
    hub_code: String,
    childOrderNumber: String?,
    orderTags: List<String>?,
    tip: Double?,
    eligiblePayout: Double?
  ) -> T): Query<T> = GetOrdersByDateQuery(date) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getLong(3)!!,
      cursor.getString(4)!!,
      cursor.getLong(5)?.let { it == 1L },
      cursor.getString(6)!!,
      cursor.getString(7)!!,
      cursor.getString(8)!!,
      cursor.getString(9)!!,
      cursor.getDouble(10)!!,
      cursor.getString(11)!!,
      cursor.getDouble(12)!!,
      cursor.getDouble(13)!!,
      cursor.getLong(14)?.let { it == 1L },
      database.OrderHistoryAdapter.event_detailsAdapter.decode(cursor.getString(15)!!),
      cursor.getString(16)!!,
      cursor.getString(17)!!,
      cursor.getString(18),
      cursor.getString(19)?.let { database.OrderHistoryAdapter.orderTagsAdapter.decode(it) },
      cursor.getDouble(20),
      cursor.getDouble(21)
    )
  }

  public override fun getOrdersByDate(date: String): Query<OrderHistory> = getOrdersByDate(date) {
      id, reference_number, date_, order_time, order_number, is_vip, rider_score, customer_name,
      customer_address, discount_type, discount_amount, payment_mode, bill_amount, cod_amount,
      is_canceled, event_details, hub_name, hub_code, childOrderNumber, orderTags, tip,
      eligiblePayout ->
    OrderHistory(
      id,
      reference_number,
      date_,
      order_time,
      order_number,
      is_vip,
      rider_score,
      customer_name,
      customer_address,
      discount_type,
      discount_amount,
      payment_mode,
      bill_amount,
      cod_amount,
      is_canceled,
      event_details,
      hub_name,
      hub_code,
      childOrderNumber,
      orderTags,
      tip,
      eligiblePayout
    )
  }

  public override fun insertCurrentOrders(
    id: Long?,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ): Unit {
    driver.execute(-1794484006, """
    |INSERT INTO CurrentOrders(id,reference_number,status,task_type,is_cod,cod_amount,is_vip,
    |is_bulk,notes,payment_details,pieces_details,order_number,order_type,otp,
    |makeline_time,final_amount,order_promise_start_time_ondemand,ondemand_delivery_promise_mins,
    |priority,ondemand_discount,lastUpdatedAt,assignTime,storageLocation,huDetails,
    |location,tip,eligible_payout,order_instructions)
    |VALUES (?,?,?,?,?,?,?,?,
    |?,?,?,?,?,?,
    |?,?,?,
    |?,?,?,?,?,?,
    |?,?,?,?,?)
    """.trimMargin(), 28) {
      bindLong(1, id)
      bindString(2, reference_number)
      bindString(3, status)
      bindString(4, task_type)
      bindLong(5, is_cod?.let { if (it) 1L else 0L })
      bindDouble(6, cod_amount)
      bindLong(7, is_vip?.let { if (it) 1L else 0L })
      bindLong(8, is_bulk?.let { if (it) 1L else 0L })
      bindString(9, notes)
      bindString(10, payment_details?.let {
          database.CurrentOrdersAdapter.payment_detailsAdapter.encode(it) })
      bindString(11, pieces_details?.let {
          database.CurrentOrdersAdapter.pieces_detailsAdapter.encode(it) })
      bindString(12, order_number)
      bindString(13, order_type)
      bindString(14, otp)
      bindLong(15, makeline_time)
      bindDouble(16, final_amount)
      bindLong(17, order_promise_start_time_ondemand)
      bindLong(18, ondemand_delivery_promise_mins)
      bindLong(19, priority)
      bindString(20, ondemand_discount?.let {
          database.CurrentOrdersAdapter.ondemand_discountAdapter.encode(it) })
      bindLong(21, lastUpdatedAt)
      bindLong(22, assignTime)
      bindString(23, storageLocation)
      bindString(24, huDetails?.let { database.CurrentOrdersAdapter.huDetailsAdapter.encode(it) })
      bindString(25, location?.let { database.CurrentOrdersAdapter.locationAdapter.encode(it) })
      bindDouble(26, tip)
      bindDouble(27, eligible_payout)
      bindString(28, order_instructions?.let {
          database.CurrentOrdersAdapter.order_instructionsAdapter.encode(it) })
    }
    notifyQueries(-1794484006, {database.appDatabaseQueries.getReferenceNumbersByOrderNumber +
        database.appDatabaseQueries.getCurrentOrdersByStatus +
        database.appDatabaseQueries.getCurrentOrderByStatusAndTaskType +
        database.appDatabaseQueries.getOrdersByReferenceNumber +
        database.appDatabaseQueries.getOrderByReferenceNumberWithTaskType +
        database.appDatabaseQueries.getCurrentOrdersByStatusPriority +
        database.appDatabaseQueries.getReferenceNumbersByOrderNumbers +
        database.appDatabaseQueries.getOrdersByReferenceNumbers +
        database.appDatabaseQueries.currentOrdersByNotStatus +
        database.appDatabaseQueries.getAllCurrentOrders})
  }

  public override fun updateOrderStatusByReferenceNumber(status: String,
      reference_number: Collection<String>): Unit {
    val reference_numberIndexes = createArguments(count = reference_number.size)
    driver.execute(null,
        """UPDATE CurrentOrders SET status = ? WHERE reference_number IN $reference_numberIndexes""",
        1 + reference_number.size) {
      bindString(1, status)
      reference_number.forEachIndexed { index, reference_number_ ->
          bindString(index + 2, reference_number_)
          }
    }
    notifyQueries(-876390511, {database.appDatabaseQueries.getReferenceNumbersByOrderNumber +
        database.appDatabaseQueries.getCurrentOrdersByStatus +
        database.appDatabaseQueries.getCurrentOrderByStatusAndTaskType +
        database.appDatabaseQueries.getOrdersByReferenceNumber +
        database.appDatabaseQueries.getOrderByReferenceNumberWithTaskType +
        database.appDatabaseQueries.getCurrentOrdersByStatusPriority +
        database.appDatabaseQueries.getReferenceNumbersByOrderNumbers +
        database.appDatabaseQueries.getOrdersByReferenceNumbers +
        database.appDatabaseQueries.currentOrdersByNotStatus +
        database.appDatabaseQueries.getAllCurrentOrders})
  }

  public override fun deleteOrderByReferenceNumber(reference_number: String): Unit {
    driver.execute(-1975056059, """DELETE FROM CurrentOrders WHERE reference_number = ?""", 1) {
      bindString(1, reference_number)
    }
    notifyQueries(-1975056059, {database.appDatabaseQueries.getReferenceNumbersByOrderNumber +
        database.appDatabaseQueries.getCurrentOrdersByStatus +
        database.appDatabaseQueries.getCurrentOrderByStatusAndTaskType +
        database.appDatabaseQueries.getOrdersByReferenceNumber +
        database.appDatabaseQueries.getOrderByReferenceNumberWithTaskType +
        database.appDatabaseQueries.getCurrentOrdersByStatusPriority +
        database.appDatabaseQueries.getReferenceNumbersByOrderNumbers +
        database.appDatabaseQueries.getOrdersByReferenceNumbers +
        database.appDatabaseQueries.currentOrdersByNotStatus +
        database.appDatabaseQueries.getAllCurrentOrders})
  }

  public override fun deleteOrderByOrderNumber(order_number: String): Unit {
    driver.execute(-218623096, """DELETE FROM CurrentOrders WHERE order_number = ?""", 1) {
      bindString(1, order_number)
    }
    notifyQueries(-218623096, {database.appDatabaseQueries.getReferenceNumbersByOrderNumber +
        database.appDatabaseQueries.getCurrentOrdersByStatus +
        database.appDatabaseQueries.getCurrentOrderByStatusAndTaskType +
        database.appDatabaseQueries.getOrdersByReferenceNumber +
        database.appDatabaseQueries.getOrderByReferenceNumberWithTaskType +
        database.appDatabaseQueries.getCurrentOrdersByStatusPriority +
        database.appDatabaseQueries.getReferenceNumbersByOrderNumbers +
        database.appDatabaseQueries.getOrdersByReferenceNumbers +
        database.appDatabaseQueries.currentOrdersByNotStatus +
        database.appDatabaseQueries.getAllCurrentOrders})
  }

  public override fun removeAllCurrentOrders(): Unit {
    driver.execute(1741455564, """DELETE FROM CurrentOrders""", 0)
    notifyQueries(1741455564, {database.appDatabaseQueries.getReferenceNumbersByOrderNumber +
        database.appDatabaseQueries.getCurrentOrdersByStatus +
        database.appDatabaseQueries.getCurrentOrderByStatusAndTaskType +
        database.appDatabaseQueries.getOrdersByReferenceNumber +
        database.appDatabaseQueries.getOrderByReferenceNumberWithTaskType +
        database.appDatabaseQueries.getCurrentOrdersByStatusPriority +
        database.appDatabaseQueries.getReferenceNumbersByOrderNumbers +
        database.appDatabaseQueries.getOrdersByReferenceNumbers +
        database.appDatabaseQueries.currentOrdersByNotStatus +
        database.appDatabaseQueries.getAllCurrentOrders})
  }

  public override fun insertRiderStateEvents(
    id: Long?,
    type: String,
    reference_numbers: List<String>,
    transaction_id: String,
    vehicle_number: String?,
    skip_vehicle_scan_reason: String?,
    timestamp: Long,
    lat: Double?,
    lng: Double?,
    payment_details: List<PaymentDetails>?,
    auto_swipe: Boolean?,
    discount: Discount?,
    reason: UndeliveredReason?,
    receiver_relation: RelationData?,
    hu_details: List<HUDetail>?,
    pieces_status_detail: List<PieceDetails>?,
    partialDeliveryReason: UndeliveredReason?,
    retryCount: Long?
  ): Unit {
    driver.execute(1955328404, """
    |INSERT INTO RiderStateEvents(id,type,reference_numbers,transaction_id,vehicle_number,
    |skip_vehicle_scan_reason,timestamp,lat,lng,payment_details,auto_swipe,discount,reason,
    |receiver_relation,hu_details,pieces_status_detail,partialDeliveryReason,retryCount)
    |VALUES (?,?,?,?,?,
    |?,?,?,?,?,?,?,?,
    |?,?,?,?,?)
    """.trimMargin(), 18) {
      bindLong(1, id)
      bindString(2, type)
      bindString(3,
          database.RiderStateEventsAdapter.reference_numbersAdapter.encode(reference_numbers))
      bindString(4, transaction_id)
      bindString(5, vehicle_number)
      bindString(6, skip_vehicle_scan_reason)
      bindLong(7, timestamp)
      bindDouble(8, lat)
      bindDouble(9, lng)
      bindString(10, payment_details?.let {
          database.RiderStateEventsAdapter.payment_detailsAdapter.encode(it) })
      bindLong(11, auto_swipe?.let { if (it) 1L else 0L })
      bindString(12, discount?.let { database.RiderStateEventsAdapter.discountAdapter.encode(it) })
      bindString(13, reason?.let { database.RiderStateEventsAdapter.reasonAdapter.encode(it) })
      bindString(14, receiver_relation?.let {
          database.RiderStateEventsAdapter.receiver_relationAdapter.encode(it) })
      bindString(15, hu_details?.let { database.RiderStateEventsAdapter.hu_detailsAdapter.encode(it)
          })
      bindString(16, pieces_status_detail?.let {
          database.RiderStateEventsAdapter.pieces_status_detailAdapter.encode(it) })
      bindString(17, partialDeliveryReason?.let {
          database.RiderStateEventsAdapter.partialDeliveryReasonAdapter.encode(it) })
      bindLong(18, retryCount)
    }
    notifyQueries(1955328404, {database.appDatabaseQueries.getRiderStateEventDataItems +
        database.appDatabaseQueries.shouldUpdateLocalState})
  }

  public override fun deleteByTransactionIds(transaction_id: Collection<String>): Unit {
    val transaction_idIndexes = createArguments(count = transaction_id.size)
    driver.execute(null,
        """DELETE FROM RiderStateEvents WHERE transaction_id IN $transaction_idIndexes""",
        transaction_id.size) {
      transaction_id.forEachIndexed { index, transaction_id_ ->
          bindString(index + 1, transaction_id_)
          }
    }
    notifyQueries(223828359, {database.appDatabaseQueries.getRiderStateEventDataItems +
        database.appDatabaseQueries.shouldUpdateLocalState})
  }

  public override fun updateTransactionCount(transaction_id: Collection<String>): Unit {
    val transaction_idIndexes = createArguments(count = transaction_id.size)
    driver.execute(null,
        """UPDATE RiderStateEvents SET retryCount = retryCount+1 WHERE transaction_id IN $transaction_idIndexes""",
        transaction_id.size) {
      transaction_id.forEachIndexed { index, transaction_id_ ->
          bindString(index + 1, transaction_id_)
          }
    }
    notifyQueries(1557057093, {database.appDatabaseQueries.getRiderStateEventDataItems +
        database.appDatabaseQueries.shouldUpdateLocalState})
  }

  public override fun removeAllRiderStateEvents(): Unit {
    driver.execute(-1531810718, """DELETE FROM RiderStateEvents""", 0)
    notifyQueries(-1531810718, {database.appDatabaseQueries.getRiderStateEventDataItems +
        database.appDatabaseQueries.shouldUpdateLocalState})
  }

  public override fun insertOrderHistory(
    id: Long?,
    reference_number: String,
    date: String,
    order_time: Long,
    order_number: String,
    is_vip: Boolean?,
    rider_score: String,
    customer_name: String,
    customer_address: String,
    discount_type: String,
    discount_amount: Double,
    payment_mode: String,
    bill_amount: Double,
    cod_amount: Double,
    is_canceled: Boolean?,
    event_details: List<DominoEventModel>,
    hub_name: String,
    hub_code: String,
    childOrderNumber: String?,
    orderTags: List<String>?,
    tip: Double?,
    eligiblePayout: Double?
  ): Unit {
    driver.execute(1967579850, """
    |INSERT INTO OrderHistory(
    |    id, reference_number, date, order_time, order_number, is_vip, rider_score, customer_name,
    |    customer_address, discount_type, discount_amount, payment_mode, bill_amount, cod_amount,
    |    is_canceled, event_details, hub_name, hub_code, childOrderNumber, orderTags, tip, eligiblePayout
    |)
    |VALUES (
    | ?, ?, ?, ?, ?, ?, ?, ?,
    | ?, ?, ?, ?, ?, ?,
    | ?, ?, ?, ?, ?,?,?,?
    |)
    """.trimMargin(), 22) {
      bindLong(1, id)
      bindString(2, reference_number)
      bindString(3, date)
      bindLong(4, order_time)
      bindString(5, order_number)
      bindLong(6, is_vip?.let { if (it) 1L else 0L })
      bindString(7, rider_score)
      bindString(8, customer_name)
      bindString(9, customer_address)
      bindString(10, discount_type)
      bindDouble(11, discount_amount)
      bindString(12, payment_mode)
      bindDouble(13, bill_amount)
      bindDouble(14, cod_amount)
      bindLong(15, is_canceled?.let { if (it) 1L else 0L })
      bindString(16, database.OrderHistoryAdapter.event_detailsAdapter.encode(event_details))
      bindString(17, hub_name)
      bindString(18, hub_code)
      bindString(19, childOrderNumber)
      bindString(20, orderTags?.let { database.OrderHistoryAdapter.orderTagsAdapter.encode(it) })
      bindDouble(21, tip)
      bindDouble(22, eligiblePayout)
    }
    notifyQueries(1967579850, {database.appDatabaseQueries.getOrdersByDate})
  }

  private inner class GetOrdersByReferenceNumberQuery<out T : Any>(
    public val reference_number: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getOrdersByReferenceNumber, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-369386099,
        """SELECT * FROM CurrentOrders WHERE reference_number = ?""", 1) {
      bindString(1, reference_number)
    }

    public override fun toString(): String = "AppDatabase.sq:getOrdersByReferenceNumber"
  }

  private inner class GetOrdersByReferenceNumbersQuery<out T : Any>(
    public val reference_number: Collection<String>,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getOrdersByReferenceNumbers, mapper) {
    public override fun execute(): SqlCursor {
      val reference_numberIndexes = createArguments(count = reference_number.size)
      return driver.executeQuery(null,
          """SELECT * FROM CurrentOrders WHERE reference_number IN $reference_numberIndexes""",
          reference_number.size) {
        reference_number.forEachIndexed { index, reference_number_ ->
            bindString(index + 1, reference_number_)
            }
      }
    }

    public override fun toString(): String = "AppDatabase.sq:getOrdersByReferenceNumbers"
  }

  private inner class GetReferenceNumbersByOrderNumberQuery<out T : Any>(
    public val order_number: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getReferenceNumbersByOrderNumber, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1904294346,
        """SELECT reference_number FROM CurrentOrders WHERE order_number = ?""", 1) {
      bindString(1, order_number)
    }

    public override fun toString(): String = "AppDatabase.sq:getReferenceNumbersByOrderNumber"
  }

  private inner class GetReferenceNumbersByOrderNumbersQuery<out T : Any>(
    public val order_number: Collection<String>,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getReferenceNumbersByOrderNumbers, mapper) {
    public override fun execute(): SqlCursor {
      val order_numberIndexes = createArguments(count = order_number.size)
      return driver.executeQuery(null,
          """SELECT reference_number FROM CurrentOrders WHERE order_number IN $order_numberIndexes""",
          order_number.size) {
        order_number.forEachIndexed { index, order_number_ ->
            bindString(index + 1, order_number_)
            }
      }
    }

    public override fun toString(): String = "AppDatabase.sq:getReferenceNumbersByOrderNumbers"
  }

  private inner class GetOrderByReferenceNumberWithTaskTypeQuery<out T : Any>(
    public val reference_number: String,
    public val task_type: String?,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getOrderByReferenceNumberWithTaskType, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(null,
        """SELECT * FROM CurrentOrders WHERE reference_number = ? AND task_type ${ if (task_type == null) "IS" else "=" } ?""",
        2) {
      bindString(1, reference_number)
      bindString(2, task_type)
    }

    public override fun toString(): String = "AppDatabase.sq:getOrderByReferenceNumberWithTaskType"
  }

  private inner class GetCurrentOrdersByStatusQuery<out T : Any>(
    public val status: Collection<String>,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getCurrentOrdersByStatus, mapper) {
    public override fun execute(): SqlCursor {
      val statusIndexes = createArguments(count = status.size)
      return driver.executeQuery(null,
          """SELECT * FROM CurrentOrders WHERE status IN $statusIndexes""", status.size) {
        status.forEachIndexed { index, status_ ->
            bindString(index + 1, status_)
            }
      }
    }

    public override fun toString(): String = "AppDatabase.sq:getCurrentOrdersByStatus"
  }

  private inner class GetCurrentOrderByStatusAndTaskTypeQuery<out T : Any>(
    public val status: Collection<String>,
    public val task_type: String?,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getCurrentOrderByStatusAndTaskType, mapper) {
    public override fun execute(): SqlCursor {
      val statusIndexes = createArguments(count = status.size)
      return driver.executeQuery(null,
          """SELECT * FROM CurrentOrders WHERE status IN $statusIndexes AND task_type ${ if (task_type == null) "IS" else "=" } ?""",
          1 + status.size) {
        status.forEachIndexed { index, status_ ->
            bindString(index + 1, status_)
            }
        bindString(status.size + 1, task_type)
      }
    }

    public override fun toString(): String = "AppDatabase.sq:getCurrentOrderByStatusAndTaskType"
  }

  private inner class GetCurrentOrdersByStatusPriorityQuery<out T : Any>(
    public val status: Collection<String>,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getCurrentOrdersByStatusPriority, mapper) {
    public override fun execute(): SqlCursor {
      val statusIndexes = createArguments(count = status.size)
      return driver.executeQuery(null,
          """SELECT * FROM CurrentOrders WHERE status IN $statusIndexes ORDER BY priority ASC""",
          status.size) {
        status.forEachIndexed { index, status_ ->
            bindString(index + 1, status_)
            }
      }
    }

    public override fun toString(): String = "AppDatabase.sq:getCurrentOrdersByStatusPriority"
  }

  private inner class CurrentOrdersByNotStatusQuery<out T : Any>(
    public val status: Collection<String>,
    mapper: (SqlCursor) -> T
  ) : Query<T>(currentOrdersByNotStatus, mapper) {
    public override fun execute(): SqlCursor {
      val statusIndexes = createArguments(count = status.size)
      return driver.executeQuery(null,
          """SELECT * FROM CurrentOrders WHERE status NOT IN $statusIndexes""", status.size) {
        status.forEachIndexed { index, status_ ->
            bindString(index + 1, status_)
            }
      }
    }

    public override fun toString(): String = "AppDatabase.sq:currentOrdersByNotStatus"
  }

  private inner class GetOrdersByDateQuery<out T : Any>(
    public val date: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getOrdersByDate, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1439536587,
        """SELECT * FROM OrderHistory WHERE date = ?""", 1) {
      bindString(1, date)
    }

    public override fun toString(): String = "AppDatabase.sq:getOrdersByDate"
  }
}
