package com.shipsy.ondemand.riderapp.shared.cache

import com.shipsy.ondemand.riderapp.framework.network.model.login.HUDetail
import com.shipsy.ondemand.riderapp.framework.network.model.login.PaymentDetails
import com.shipsy.ondemand.riderapp.framework.network.model.login.PieceDetails
import com.shipsy.ondemand.riderapp.framework.network.model.login.RelationData
import com.shipsy.ondemand.riderapp.framework.network.model.login.UndeliveredReason
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.Discount
import com.squareup.sqldelight.ColumnAdapter
import kotlin.Boolean
import kotlin.Double
import kotlin.Long
import kotlin.String
import kotlin.collections.List

public data class RiderStateEvents(
  public val id: Long,
  public val type: String,
  public val reference_numbers: List<String>,
  public val transaction_id: String,
  public val vehicle_number: String?,
  public val skip_vehicle_scan_reason: String?,
  public val timestamp: Long,
  public val lat: Double?,
  public val lng: Double?,
  public val payment_details: List<PaymentDetails>?,
  public val auto_swipe: Boolean?,
  public val discount: Discount?,
  public val reason: UndeliveredReason?,
  public val receiver_relation: RelationData?,
  public val hu_details: List<HUDetail>?,
  public val pieces_status_detail: List<PieceDetails>?,
  public val partialDeliveryReason: UndeliveredReason?,
  public val retryCount: Long?
) {
  public override fun toString(): String = """
  |RiderStateEvents [
  |  id: $id
  |  type: $type
  |  reference_numbers: $reference_numbers
  |  transaction_id: $transaction_id
  |  vehicle_number: $vehicle_number
  |  skip_vehicle_scan_reason: $skip_vehicle_scan_reason
  |  timestamp: $timestamp
  |  lat: $lat
  |  lng: $lng
  |  payment_details: $payment_details
  |  auto_swipe: $auto_swipe
  |  discount: $discount
  |  reason: $reason
  |  receiver_relation: $receiver_relation
  |  hu_details: $hu_details
  |  pieces_status_detail: $pieces_status_detail
  |  partialDeliveryReason: $partialDeliveryReason
  |  retryCount: $retryCount
  |]
  """.trimMargin()

  public class Adapter(
    public val reference_numbersAdapter: ColumnAdapter<List<String>, String>,
    public val payment_detailsAdapter: ColumnAdapter<List<PaymentDetails>, String>,
    public val discountAdapter: ColumnAdapter<Discount, String>,
    public val reasonAdapter: ColumnAdapter<UndeliveredReason, String>,
    public val receiver_relationAdapter: ColumnAdapter<RelationData, String>,
    public val hu_detailsAdapter: ColumnAdapter<List<HUDetail>, String>,
    public val pieces_status_detailAdapter: ColumnAdapter<List<PieceDetails>, String>,
    public val partialDeliveryReasonAdapter: ColumnAdapter<UndeliveredReason, String>
  )
}
