package com.shipsy.ondemand.riderapp.shared.cache

import com.shipsy.ondemand.riderapp.framework.`data`.orderhistory.DominoEventModel
import com.squareup.sqldelight.ColumnAdapter
import kotlin.Boolean
import kotlin.Double
import kotlin.Long
import kotlin.String
import kotlin.collections.List

public data class OrderHistory(
  public val id: Long,
  public val reference_number: String,
  public val date: String,
  public val order_time: Long,
  public val order_number: String,
  public val is_vip: Boolean?,
  public val rider_score: String,
  public val customer_name: String,
  public val customer_address: String,
  public val discount_type: String,
  public val discount_amount: Double,
  public val payment_mode: String,
  public val bill_amount: Double,
  public val cod_amount: Double,
  public val is_canceled: Boolean?,
  public val event_details: List<DominoEventModel>,
  public val hub_name: String,
  public val hub_code: String,
  public val childOrderNumber: String?,
  public val orderTags: List<String>?,
  public val tip: Double?,
  public val eligiblePayout: Double?
) {
  public override fun toString(): String = """
  |OrderHistory [
  |  id: $id
  |  reference_number: $reference_number
  |  date: $date
  |  order_time: $order_time
  |  order_number: $order_number
  |  is_vip: $is_vip
  |  rider_score: $rider_score
  |  customer_name: $customer_name
  |  customer_address: $customer_address
  |  discount_type: $discount_type
  |  discount_amount: $discount_amount
  |  payment_mode: $payment_mode
  |  bill_amount: $bill_amount
  |  cod_amount: $cod_amount
  |  is_canceled: $is_canceled
  |  event_details: $event_details
  |  hub_name: $hub_name
  |  hub_code: $hub_code
  |  childOrderNumber: $childOrderNumber
  |  orderTags: $orderTags
  |  tip: $tip
  |  eligiblePayout: $eligiblePayout
  |]
  """.trimMargin()

  public class Adapter(
    public val event_detailsAdapter: ColumnAdapter<List<DominoEventModel>, String>,
    public val orderTagsAdapter: ColumnAdapter<List<String>, String>
  )
}
