package com.shipsy.ondemand.riderapp.shared.cache

import com.shipsy.ondemand.riderapp.framework.network.model.login.HUDetail
import com.shipsy.ondemand.riderapp.framework.network.model.login.Location
import com.shipsy.ondemand.riderapp.framework.network.model.login.OnDemandDiscount
import com.shipsy.ondemand.riderapp.framework.network.model.login.PaymentDetails
import com.shipsy.ondemand.riderapp.framework.network.model.login.PieceDetails
import com.squareup.sqldelight.ColumnAdapter
import kotlin.Boolean
import kotlin.Double
import kotlin.Long
import kotlin.String
import kotlin.collections.List

public data class CurrentOrders(
  public val id: Long,
  public val reference_number: String,
  public val status: String,
  public val task_type: String?,
  public val is_cod: Boolean?,
  public val cod_amount: Double?,
  public val is_vip: Boolean?,
  public val is_bulk: Boolean?,
  public val notes: String?,
  public val payment_details: List<PaymentDetails>?,
  public val pieces_details: List<PieceDetails>?,
  public val order_number: String,
  public val order_type: String?,
  public val otp: String?,
  public val makeline_time: Long?,
  public val final_amount: Double?,
  public val order_promise_start_time_ondemand: Long?,
  public val ondemand_delivery_promise_mins: Long?,
  public val priority: Long?,
  public val ondemand_discount: OnDemandDiscount?,
  public val lastUpdatedAt: Long?,
  public val assignTime: Long?,
  public val storageLocation: String?,
  public val huDetails: List<HUDetail>?,
  public val location: Location?,
  public val tip: Double?,
  public val eligible_payout: Double?,
  public val order_instructions: List<String>?
) {
  public override fun toString(): String = """
  |CurrentOrders [
  |  id: $id
  |  reference_number: $reference_number
  |  status: $status
  |  task_type: $task_type
  |  is_cod: $is_cod
  |  cod_amount: $cod_amount
  |  is_vip: $is_vip
  |  is_bulk: $is_bulk
  |  notes: $notes
  |  payment_details: $payment_details
  |  pieces_details: $pieces_details
  |  order_number: $order_number
  |  order_type: $order_type
  |  otp: $otp
  |  makeline_time: $makeline_time
  |  final_amount: $final_amount
  |  order_promise_start_time_ondemand: $order_promise_start_time_ondemand
  |  ondemand_delivery_promise_mins: $ondemand_delivery_promise_mins
  |  priority: $priority
  |  ondemand_discount: $ondemand_discount
  |  lastUpdatedAt: $lastUpdatedAt
  |  assignTime: $assignTime
  |  storageLocation: $storageLocation
  |  huDetails: $huDetails
  |  location: $location
  |  tip: $tip
  |  eligible_payout: $eligible_payout
  |  order_instructions: $order_instructions
  |]
  """.trimMargin()

  public class Adapter(
    public val payment_detailsAdapter: ColumnAdapter<List<PaymentDetails>, String>,
    public val pieces_detailsAdapter: ColumnAdapter<List<PieceDetails>, String>,
    public val ondemand_discountAdapter: ColumnAdapter<OnDemandDiscount, String>,
    public val huDetailsAdapter: ColumnAdapter<List<HUDetail>, String>,
    public val locationAdapter: ColumnAdapter<Location, String>,
    public val order_instructionsAdapter: ColumnAdapter<List<String>, String>
  )
}
