package com.shipsy.ondemand.riderapp.shared.cache

import com.shipsy.ondemand.riderapp.framework.`data`.orderhistory.DominoEventModel
import com.shipsy.ondemand.riderapp.framework.network.model.login.HUDetail
import com.shipsy.ondemand.riderapp.framework.network.model.login.Location
import com.shipsy.ondemand.riderapp.framework.network.model.login.OnDemandDiscount
import com.shipsy.ondemand.riderapp.framework.network.model.login.PaymentDetails
import com.shipsy.ondemand.riderapp.framework.network.model.login.PieceDetails
import com.shipsy.ondemand.riderapp.framework.network.model.login.RelationData
import com.shipsy.ondemand.riderapp.framework.network.model.login.UndeliveredReason
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.Discount
import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.List

public interface AppDatabaseQueries : Transacter {
  public fun <T : Any> getOrdersByReferenceNumber(reference_number: String, mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T>

  public fun getOrdersByReferenceNumber(reference_number: String): Query<CurrentOrders>

  public fun <T : Any> getOrdersByReferenceNumbers(reference_number: Collection<String>, mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T>

  public fun getOrdersByReferenceNumbers(reference_number: Collection<String>): Query<CurrentOrders>

  public fun getReferenceNumbersByOrderNumber(order_number: String): Query<String>

  public fun getReferenceNumbersByOrderNumbers(order_number: Collection<String>): Query<String>

  public fun <T : Any> getOrderByReferenceNumberWithTaskType(
    reference_number: String,
    task_type: String?,
    mapper: (
      id: Long,
      reference_number: String,
      status: String,
      task_type: String?,
      is_cod: Boolean?,
      cod_amount: Double?,
      is_vip: Boolean?,
      is_bulk: Boolean?,
      notes: String?,
      payment_details: List<PaymentDetails>?,
      pieces_details: List<PieceDetails>?,
      order_number: String,
      order_type: String?,
      otp: String?,
      makeline_time: Long?,
      final_amount: Double?,
      order_promise_start_time_ondemand: Long?,
      ondemand_delivery_promise_mins: Long?,
      priority: Long?,
      ondemand_discount: OnDemandDiscount?,
      lastUpdatedAt: Long?,
      assignTime: Long?,
      storageLocation: String?,
      huDetails: List<HUDetail>?,
      location: Location?,
      tip: Double?,
      eligible_payout: Double?,
      order_instructions: List<String>?
    ) -> T
  ): Query<T>

  public fun getOrderByReferenceNumberWithTaskType(reference_number: String, task_type: String?):
      Query<CurrentOrders>

  public fun <T : Any> getAllCurrentOrders(mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T>

  public fun getAllCurrentOrders(): Query<CurrentOrders>

  public fun <T : Any> getCurrentOrdersByStatus(status: Collection<String>, mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T>

  public fun getCurrentOrdersByStatus(status: Collection<String>): Query<CurrentOrders>

  public fun <T : Any> getCurrentOrderByStatusAndTaskType(
    status: Collection<String>,
    task_type: String?,
    mapper: (
      id: Long,
      reference_number: String,
      status: String,
      task_type: String?,
      is_cod: Boolean?,
      cod_amount: Double?,
      is_vip: Boolean?,
      is_bulk: Boolean?,
      notes: String?,
      payment_details: List<PaymentDetails>?,
      pieces_details: List<PieceDetails>?,
      order_number: String,
      order_type: String?,
      otp: String?,
      makeline_time: Long?,
      final_amount: Double?,
      order_promise_start_time_ondemand: Long?,
      ondemand_delivery_promise_mins: Long?,
      priority: Long?,
      ondemand_discount: OnDemandDiscount?,
      lastUpdatedAt: Long?,
      assignTime: Long?,
      storageLocation: String?,
      huDetails: List<HUDetail>?,
      location: Location?,
      tip: Double?,
      eligible_payout: Double?,
      order_instructions: List<String>?
    ) -> T
  ): Query<T>

  public fun getCurrentOrderByStatusAndTaskType(status: Collection<String>, task_type: String?):
      Query<CurrentOrders>

  public fun <T : Any> getCurrentOrdersByStatusPriority(status: Collection<String>, mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T>

  public fun getCurrentOrdersByStatusPriority(status: Collection<String>): Query<CurrentOrders>

  public fun <T : Any> currentOrdersByNotStatus(status: Collection<String>, mapper: (
    id: Long,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ) -> T): Query<T>

  public fun currentOrdersByNotStatus(status: Collection<String>): Query<CurrentOrders>

  public fun <T : Any> getRiderStateEventDataItems(mapper: (
    id: Long,
    type: String,
    reference_numbers: List<String>,
    transaction_id: String,
    vehicle_number: String?,
    skip_vehicle_scan_reason: String?,
    timestamp: Long,
    lat: Double?,
    lng: Double?,
    payment_details: List<PaymentDetails>?,
    auto_swipe: Boolean?,
    discount: Discount?,
    reason: UndeliveredReason?,
    receiver_relation: RelationData?,
    hu_details: List<HUDetail>?,
    pieces_status_detail: List<PieceDetails>?,
    partialDeliveryReason: UndeliveredReason?,
    retryCount: Long?
  ) -> T): Query<T>

  public fun getRiderStateEventDataItems(): Query<RiderStateEvents>

  public fun <T : Any> shouldUpdateLocalState(mapper: (
    id: Long,
    type: String,
    reference_numbers: List<String>,
    transaction_id: String,
    vehicle_number: String?,
    skip_vehicle_scan_reason: String?,
    timestamp: Long,
    lat: Double?,
    lng: Double?,
    payment_details: List<PaymentDetails>?,
    auto_swipe: Boolean?,
    discount: Discount?,
    reason: UndeliveredReason?,
    receiver_relation: RelationData?,
    hu_details: List<HUDetail>?,
    pieces_status_detail: List<PieceDetails>?,
    partialDeliveryReason: UndeliveredReason?,
    retryCount: Long?
  ) -> T): Query<T>

  public fun shouldUpdateLocalState(): Query<RiderStateEvents>

  public fun <T : Any> getOrdersByDate(date: String, mapper: (
    id: Long,
    reference_number: String,
    date: String,
    order_time: Long,
    order_number: String,
    is_vip: Boolean?,
    rider_score: String,
    customer_name: String,
    customer_address: String,
    discount_type: String,
    discount_amount: Double,
    payment_mode: String,
    bill_amount: Double,
    cod_amount: Double,
    is_canceled: Boolean?,
    event_details: List<DominoEventModel>,
    hub_name: String,
    hub_code: String,
    childOrderNumber: String?,
    orderTags: List<String>?,
    tip: Double?,
    eligiblePayout: Double?
  ) -> T): Query<T>

  public fun getOrdersByDate(date: String): Query<OrderHistory>

  public fun insertCurrentOrders(
    id: Long?,
    reference_number: String,
    status: String,
    task_type: String?,
    is_cod: Boolean?,
    cod_amount: Double?,
    is_vip: Boolean?,
    is_bulk: Boolean?,
    notes: String?,
    payment_details: List<PaymentDetails>?,
    pieces_details: List<PieceDetails>?,
    order_number: String,
    order_type: String?,
    otp: String?,
    makeline_time: Long?,
    final_amount: Double?,
    order_promise_start_time_ondemand: Long?,
    ondemand_delivery_promise_mins: Long?,
    priority: Long?,
    ondemand_discount: OnDemandDiscount?,
    lastUpdatedAt: Long?,
    assignTime: Long?,
    storageLocation: String?,
    huDetails: List<HUDetail>?,
    location: Location?,
    tip: Double?,
    eligible_payout: Double?,
    order_instructions: List<String>?
  ): Unit

  public fun updateOrderStatusByReferenceNumber(status: String,
      reference_number: Collection<String>): Unit

  public fun deleteOrderByReferenceNumber(reference_number: String): Unit

  public fun deleteOrderByOrderNumber(order_number: String): Unit

  public fun removeAllCurrentOrders(): Unit

  public fun insertRiderStateEvents(
    id: Long?,
    type: String,
    reference_numbers: List<String>,
    transaction_id: String,
    vehicle_number: String?,
    skip_vehicle_scan_reason: String?,
    timestamp: Long,
    lat: Double?,
    lng: Double?,
    payment_details: List<PaymentDetails>?,
    auto_swipe: Boolean?,
    discount: Discount?,
    reason: UndeliveredReason?,
    receiver_relation: RelationData?,
    hu_details: List<HUDetail>?,
    pieces_status_detail: List<PieceDetails>?,
    partialDeliveryReason: UndeliveredReason?,
    retryCount: Long?
  ): Unit

  public fun deleteByTransactionIds(transaction_id: Collection<String>): Unit

  public fun updateTransactionCount(transaction_id: Collection<String>): Unit

  public fun removeAllRiderStateEvents(): Unit

  public fun insertOrderHistory(
    id: Long?,
    reference_number: String,
    date: String,
    order_time: Long,
    order_number: String,
    is_vip: Boolean?,
    rider_score: String,
    customer_name: String,
    customer_address: String,
    discount_type: String,
    discount_amount: Double,
    payment_mode: String,
    bill_amount: Double,
    cod_amount: Double,
    is_canceled: Boolean?,
    event_details: List<DominoEventModel>,
    hub_name: String,
    hub_code: String,
    childOrderNumber: String?,
    orderTags: List<String>?,
    tip: Double?,
    eligiblePayout: Double?
  ): Unit
}
