package com.shipsy.ondemand.riderapp.shared.cache

import com.shipsy.ondemand.riderapp.shared.cache.shared.newInstance
import com.shipsy.ondemand.riderapp.shared.cache.shared.schema
import com.squareup.sqldelight.Transacter
import com.squareup.sqldelight.db.SqlDriver

public interface AppDatabase : Transacter {
  public val appDatabaseQueries: AppDatabaseQueries

  public companion object {
    public val Schema: SqlDriver.Schema
      get() = AppDatabase::class.schema

    public operator fun invoke(
      driver: SqlDriver,
      CurrentOrdersAdapter: CurrentOrders.Adapter,
      OrderHistoryAdapter: OrderHistory.Adapter,
      RiderStateEventsAdapter: RiderStateEvents.Adapter
    ): AppDatabase = AppDatabase::class.newInstance(driver, CurrentOrdersAdapter,
        OrderHistoryAdapter, RiderStateEventsAdapter)
  }
}
