package com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler

import com.shipsy.ondemand.core.domain.SuspendingUseCase
import com.shipsy.ondemand.riderapp.domain.const.SyncType
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.framework.network.model.login.HUDetail
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.framework.network.model.login.UndeliveredReason

interface UnDeliveredEventUseCase :
    SuspendingUseCase<UnDeliveredEventUseCase.Input, UseCaseResult<RiderStateResponse>> {
    data class Input(
        val referenceNumber: String,
        val huDetails: List<HUDetail>,
        val syncType: SyncType,
        val handleGeofenceError: (
            blockOrderProcessing: Boolean, response: suspend (moveForward: Boolean) -> Unit
        ) -> Unit,
        val handleUndeliveredReasonSelection: (
            response: suspend (moveForward: Boolean, reason: UndeliveredReason) -> Unit
        ) -> Unit
    )

}