package com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler

import com.shipsy.ondemand.core.domain.SuspendingUseCase

interface SuspiciousCheckUseCase :
    SuspendingUseCase<SuspiciousCheckUseCase.Input, SuspiciousCheckUseCase.Output> {

    data class Input(
        val eventType: String,
        val checkWith: LocationCheckFrom
    )

    sealed class LocationCheckFrom {
        data class Order(val referenceNumber: String) : LocationCheckFrom()
        object Hub : LocationCheckFrom()
    }

    data class Output(
        val showWarning: Boolean,
        val blockOrderProcessing: Boolean
    )
}