package com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler

import com.shipsy.ondemand.core.domain.SuspendingUseCase
import com.shipsy.ondemand.riderapp.domain.const.SyncType
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse

interface StartBikeEventUseCase :
    SuspendingUseCase<StartBikeEventUseCase.Input, UseCaseResult<RiderStateResponse>> {
    data class Input(
        val referenceNumbers: List<String>,
        val syncType: SyncType,
        val autoSwipe: Boolean = false,
        val handleGeofenceError: ((
            blockOrderProcessing: Boolean, response: suspend (moveForward: Boolean) -> Unit
        ) -> Unit)? = null
    )

}