package com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler

import com.shipsy.ondemand.core.domain.SuspendingUseCase
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.domain.const.SyncType
import com.shipsy.ondemand.riderapp.framework.network.model.login.HUDetail
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse

interface PickupCompletedEventUseCase :
    SuspendingUseCase<PickupCompletedEventUseCase.Input, UseCaseResult<RiderStateResponse>> {
    data class Input(
        val referenceNumbers: List<String>,
        val huDetails: List<HUDetail>,
        val syncType: SyncType,
        val handleOtpInput: (
            response: suspend () -> Unit
        ) -> Unit,
    )
}