package com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler

import com.shipsy.ondemand.core.domain.SuspendingUseCase
import com.shipsy.ondemand.riderapp.domain.const.SyncType
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse

interface PickingProcessStartedEventUseCase :
    SuspendingUseCase<PickingProcessStartedEventUseCase.Input, UseCaseResult<RiderStateResponse>> {
    data class Input(
        val referenceNumbers: List<String>? = null,
        val orderNumber: String? = null,
        val syncType: SyncType,
        val autoSwipe: Boolean = false,
        val handleGeofenceError: ((
            blockOrderProcessing: Boolean, response: suspend (moveForward: Boolean) -> Unit
        ) -> Unit)? = null
    )
}