package com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler

import com.shipsy.ondemand.core.domain.SuspendingUseCase
import com.shipsy.ondemand.riderapp.domain.const.SyncType
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.framework.network.model.login.HUDetail
import com.shipsy.ondemand.riderapp.framework.network.model.login.PaymentDetails
import com.shipsy.ondemand.riderapp.framework.network.model.login.RelationData
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse

interface DeliveredEventUseCase :
    SuspendingUseCase<DeliveredEventUseCase.Input, UseCaseResult<RiderStateResponse>> {
    data class Input(
        val referenceNumber: String,
        val syncType: SyncType,
        val handleGeofenceError: (
            blockOrderProcessing: Boolean, response: suspend (moveForward: Boolean) -> Unit
        ) -> Unit,
        val handleReceiverRelationInput: (
            response: suspend (reason: RelationData) -> Unit
        ) -> Unit,
        val handlePaymentDetailInput: (
            response: suspend (reason: PaymentDetails) -> Unit
        ) -> Unit,
        val handleDeliveryScan: (
            response: suspend (huDetails: List<HUDetail>) -> Unit
        ) -> Unit,
        val handleOtpInput: (
            response: suspend () -> Unit
        ) -> Unit,
    )

}