package com.shipsy.ondemand.riderapp.interactor.usecase.codsettlement

import com.shipsy.ondemand.core.domain.SuspendingUseCase
import com.shipsy.ondemand.riderapp.framework.data.codsettlement.CashSettlementData
import com.shipsy.ondemand.core.framework.network.UseCaseResult

/**
 * Created by Kalpesh Kundanani on 30/09/22
 */
interface RaiseCODSettlementRequestUseCase :
    SuspendingUseCase<RaiseCODSettlementRequestUseCase.Input, UseCaseResult<Boolean>> {
    data class Input(
        val hub: String,
        val payout: Double? = null,
        val settlements: List<CashSettlementData>,
        val cashBulkId: String? = null,
        val paymentMode: String? = null,
        var imageAsBytes: ByteArray? = null,
    )
}