package com.shipsy.ondemand.riderapp.interactor.repository

import com.shipsy.ondemand.riderapp.framework.data.loginhistory.LoginHistoryData
import com.shipsy.ondemand.riderapp.framework.data.orderhistory.OrderHistoryData
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.WithdrawRequestModel
import com.shipsy.ondemand.riderapp.framework.network.model.transactionhistory.TransactionData
import com.shipsy.ondemand.riderapp.framework.network.model.transactionhistory.TransactionHistoryRequestBody

/**
 * Created by Kalpesh Kundanani on 22/08/22
 */
interface HistoryRepository {
    suspend fun getOrderHistory(fromDate: String, toDate: String): BaseResponse<OrderHistoryData>
    suspend fun getLoginHistory(ofDate: String): BaseResponse<LoginHistoryData>

    // Transaction History
    suspend fun fetchRejectedRequests(body: TransactionHistoryRequestBody): BaseResponse<TransactionData>
    suspend fun fetchApprovedRequests(body: TransactionHistoryRequestBody): BaseResponse<TransactionData>
    suspend fun fetchRaisedRequests(body: TransactionHistoryRequestBody): BaseResponse<TransactionData>
    suspend fun postWithdrawRequest(body: WithdrawRequestModel): BaseResponse<Boolean?>
}