package com.shipsy.ondemand.riderapp.interactor

import com.shipsy.finance.models.network.FinanceData
import com.shipsy.finance.models.network.FinanceResponse
import com.shipsy.finance.models.network.PayoutData
import com.shipsy.finance.models.network.PayoutResponse
import com.shipsy.ondemand.riderapp.framework.data.codsettlement.CashSettlementListRequest
import com.shipsy.ondemand.riderapp.framework.data.codsettlement.CashSettlementRequest
import com.shipsy.ondemand.riderapp.framework.data.codsettlement.SettlementData
import com.shipsy.ondemand.riderapp.framework.data.loginhistory.LoginHistoryData
import com.shipsy.ondemand.riderapp.framework.data.orderhistory.OrderHistoryData
import com.shipsy.ondemand.riderapp.framework.data.sdk.SDKMasterDataFetchResponse
import com.shipsy.ondemand.riderapp.framework.data.sdk.SdkAppSettings
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.UserLogin
import com.shipsy.ondemand.riderapp.framework.network.model.WithdrawRequestModel
import com.shipsy.ondemand.riderapp.framework.network.model.checkin.CheckInRequest
import com.shipsy.ondemand.riderapp.framework.network.model.checkout.CheckoutRequest
import com.shipsy.ondemand.riderapp.framework.network.model.codsettlement.CreateQrCodeRequestBody
import com.shipsy.ondemand.riderapp.framework.network.model.codsettlement.CreateQrCodeResponse
import com.shipsy.ondemand.riderapp.framework.network.model.file.ImageTypeModel
import com.shipsy.ondemand.riderapp.framework.network.model.file.UploadDocumentsData
import com.shipsy.ondemand.riderapp.framework.network.model.login.AppConfigurationData
import com.shipsy.ondemand.riderapp.framework.network.model.login.AppUpdate
import com.shipsy.ondemand.riderapp.framework.network.model.login.LoginResponse
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.framework.network.model.order.UpcomingOrdersModel
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.RiderStateRequest
import com.shipsy.ondemand.riderapp.framework.network.model.transactionhistory.TransactionData
import com.shipsy.ondemand.riderapp.framework.network.model.transactionhistory.TransactionHistoryRequestBody
import com.shipsy.ondemand.riderapp.interactor.data.OrgLoginResponse
import com.shipsy.ondemand.riderapp.models.CallStatusRequest
import com.shipsy.ondemand.riderapp.models.CallStatusUpdateResponse

interface NetworkClient {
    suspend fun getOrgDetails(orgName: String): OrgLoginResponse?
    suspend fun login(user: UserLogin): LoginResponse
    suspend fun checkIn(workerId: String, checkInRequest: CheckInRequest): RiderStateResponse?
    suspend fun fetchRiderState(): RiderStateResponse
    suspend fun postRiderEvents(riderEvent: RiderStateRequest): RiderStateResponse
    suspend fun checkoutRider(
        workerId: String,
        checkoutRequest: CheckoutRequest
    ): BaseResponse<Boolean?>

    suspend fun fetchUpcomingOrders(hubCode: String): BaseResponse<UpcomingOrdersModel?>
    suspend fun logoutUser(): BaseResponse<Boolean?>
    suspend fun fcmTokenUpdate(token: String): BaseResponse<Boolean?>
    suspend fun getOrderHistory(fromDate: String, toDate: String): BaseResponse<OrderHistoryData>
    suspend fun fetchAppSetting(workerId: String): BaseResponse<AppConfigurationData>
    suspend fun getUrlForStorage(model: ImageTypeModel): BaseResponse<UploadDocumentsData>
    suspend fun uploadFile(uploadUrl: String, bytes: ByteArray)
    suspend fun getLoginHistory(ofDate: String): BaseResponse<LoginHistoryData>
    suspend fun fetchCodTasks(body: CashSettlementListRequest): BaseResponse<SettlementData>
    suspend fun postCashSettlementRequest(body: List<CashSettlementRequest>): BaseResponse<Boolean?>
    suspend fun createQrCode(body: CreateQrCodeRequestBody): BaseResponse<CreateQrCodeResponse>
    suspend fun fetchRejectedRequests(body: TransactionHistoryRequestBody): BaseResponse<TransactionData>
    suspend fun fetchApprovedRequests(body: TransactionHistoryRequestBody): BaseResponse<TransactionData>
    suspend fun fetchRaisedRequests(body: TransactionHistoryRequestBody): BaseResponse<TransactionData>
    suspend fun postWithdrawRequest(body: WithdrawRequestModel): BaseResponse<Boolean?>
    suspend fun sdkMasterDataFetch() : BaseResponse<SDKMasterDataFetchResponse>
    suspend fun checkSdkHealth(): BaseResponse<SdkAppSettings>
    suspend fun updateCallReasonSelection(body: CallStatusRequest): BaseResponse<CallStatusUpdateResponse>
    suspend fun checkForUpdate(workerId: String): BaseResponse<AppUpdate>

    //finance module network calls
    suspend fun getFinanceScreenData(date:String): BaseResponse<FinanceResponse>

    suspend fun getRiderPayout(
        month: String,
        year: String,
        week: String,
        date: String,
        referenceNumber: String
    ): BaseResponse<PayoutData?>

}